/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.Service;
import tigase.http.java.AsyncContextImpl;
import tigase.http.java.DummyServletRequest;
import tigase.http.java.DummyServletResponse;

public class RequestHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(RequestHandler.class.getCanonicalName());
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String contextPath;
    private final Map<String, HttpServlet> servlets = new ConcurrentHashMap<String, HttpServlet>();
    private final Service service;
    private final Timer timer;
    private static final ThreadLocal<Integer> executionTimeout = ThreadLocal.withInitial(() -> 60000);
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int val1 = o1.length() - o1.replace("/", "").length();
            int val2 = o2.length() - o2.replace("/", "").length();
            if (val2 != val1) {
                return val2 - val1;
            }
            return Integer.compare(o2.length(), o1.length());
        }
    };

    public static void setExecutionTimeout(Integer timeout) {
        executionTimeout.set(timeout);
    }

    public RequestHandler(DeploymentInfo info, Timer timer) {
        ServletInfo[] servletInfos;
        this.timer = timer;
        this.contextPath = info.getContextPath();
        this.service = info.getService();
        ServletInfo[] servletInfoArray = servletInfos = info.getServlets();
        int n = servletInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ServletInfo servletInfo = servletInfoArray[n2];
            this.registerServlet(servletInfo);
            ++n2;
        }
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        DummyServletRequest req = null;
        DummyServletResponse resp = null;
        final int reqId = counter.incrementAndGet();
        final Thread current = Thread.currentThread();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                log.log(Level.WARNING, "request processing time exceeded! for id = " + reqId);
                current.interrupt();
            }
        };
        this.timer.schedule(tt, executionTimeout.get().intValue());
        boolean exception = false;
        try {
            String path = he.getRequestURI().getPath();
            log.log(Level.FINEST, "received request for path = " + path);
            ArrayList<String> keys = new ArrayList<String>(this.servlets.keySet());
            Collections.sort(keys, COMPARATOR);
            boolean handled = false;
            for (String key : keys) {
                if (!path.startsWith(key)) continue;
                HttpServlet servlet = this.servlets.get(key);
                if (servlet == null) break;
                String servletPath = key.substring(this.contextPath.length(), key.length());
                if (servletPath.isEmpty()) {
                    servletPath = "/";
                }
                req = new DummyServletRequest(he, this.contextPath, servletPath, this.service, this.timer, executionTimeout.get());
                resp = new DummyServletResponse(he);
                if (key.endsWith(path) && !key.equals("/")) {
                    String query = req.getQueryString();
                    if (query == null || query.isEmpty()) {
                        resp.sendRedirect(String.valueOf(req.getRequestURI()) + "/");
                    } else {
                        resp.sendRedirect(String.valueOf(req.getRequestURI()) + "/?" + query);
                    }
                    return;
                }
                servlet.service((ServletRequest)req, (ServletResponse)resp);
                handled = true;
                break;
            }
            if (!handled) {
                he.sendResponseHeaders(404, -1L);
            }
        }
        catch (IOException ex) {
            tt.cancel();
            AsyncContext async = req.getAsyncContext();
            if (async != null && async instanceof AsyncContextImpl) {
                ((AsyncContextImpl)async).cancel();
            }
            throw new IOException(ex);
        }
        catch (Throwable ex) {
            exception = true;
            log.log(Level.FINEST, "Exception during processing HTTP request for id = " + reqId, ex);
            try {
                he.sendResponseHeaders(500, -1L);
            }
            catch (IOException iOException) {}
        }
        if (req != null && resp != null) {
            AsyncContext async = req.getAsyncContext();
            if (async == null || exception) {
                try {
                    resp.flushBuffer();
                }
                catch (IOException iOException) {}
                if (async instanceof AsyncContextImpl) {
                    ((AsyncContextImpl)async).cancel();
                }
                he.close();
            }
        } else {
            he.close();
        }
        tt.cancel();
    }

    private void registerServlet(ServletInfo info) {
        try {
            HttpServlet servlet = info.getServletClass().newInstance();
            ServletCfg cfg = new ServletCfg(info.getInitParams());
            servlet.init((ServletConfig)cfg);
            for (String mapping : info.getMappings()) {
                if (mapping.endsWith("/")) {
                    mapping = mapping.substring(0, mapping.length() - 1);
                }
                this.servlets.put(String.valueOf(this.contextPath) + mapping.replace("/*", ""), servlet);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(RequestHandler.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private class ServletCfg
    implements ServletConfig {
        private final Map<String, String> params = new HashMap<String, String>();

        public ServletCfg(Map<String, String> map) {
            this.params.putAll(map);
        }

        public String getServletName() {
            return null;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String string) {
            return this.params.get(string);
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }
    }
}

