/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServletInfo;

public class IndexModule
extends AbstractModule {
    private static final ConcurrentHashMap<String, IndexModule> modules = new ConcurrentHashMap();
    private final String uuid = UUID.randomUUID().toString();
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String[] vhosts = null;

    @Override
    public String getName() {
        return "index";
    }

    @Override
    public String getDescription() {
        return "Index of all available HTTP endpoints";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        modules.put(this.uuid, this);
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("Index").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = HttpServer.servlet("IndexServlet", IndexServlet.class);
        servletInfo.addInitParam("module", this.uuid);
        servletInfo.addMapping("/");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        modules.remove(this.uuid, this);
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/");
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        this.vhosts = (String[])props.get("vhosts");
    }

    public static IndexModule getInstance(String uuid) {
        return modules.get(uuid);
    }

    protected List<DeploymentInfo> listDeployments() {
        return this.httpServer.listDeployed();
    }

    public static class IndexServlet
    extends HttpServlet {
        private IndexModule module;
        private GStringTemplateEngine templateEngine = new GStringTemplateEngine();
        private Template template = null;

        public void init() throws ServletException {
            super.init();
            ServletConfig config = super.getServletConfig();
            String uuid = config.getInitParameter("module");
            if (uuid == null) {
                throw new ServletException("Missing module parameter!");
            }
            this.module = IndexModule.getInstance(uuid);
            if (this.module == null) {
                throw new ServletException("Not found module for IndexServlet");
            }
            try {
                this.loadTemplate();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new ServletException("Could not load template", (Throwable)ex);
            }
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            try {
                this.loadTemplate();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new ServletException("Could not load template", (Throwable)ex);
            }
            PrintWriter out = resp.getWriter();
            ArrayList<DeploymentInfo> deploymentInfoList = new ArrayList<DeploymentInfo>(this.module.listDeployments());
            deploymentInfoList.removeIf(info -> {
                if (info.getVHosts() != null && info.getVHosts().length > 0) {
                    List<String> vhosts = Arrays.asList(info.getVHosts());
                    return !vhosts.contains(req.getServerName());
                }
                return false;
            });
            deploymentInfoList.sort((o1, o2) -> o1.getContextPath().compareTo(o2.getContextPath()));
            HashMap<String, ArrayList<DeploymentInfo>> model = new HashMap<String, ArrayList<DeploymentInfo>>();
            model.put("deployments", deploymentInfoList);
            Writable w = this.template.make(model);
            w.writeTo((Writer)out);
        }

        private void loadTemplate() throws IOException, ClassNotFoundException {
            String path = "tigase/index/index.html";
            File indexFile = new File(path);
            if (indexFile.exists()) {
                this.template = this.templateEngine.createTemplate(indexFile);
            } else {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + path);
                this.template = this.templateEngine.createTemplate((Reader)new InputStreamReader(is));
            }
        }
    }
}

