/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.rest;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.rest.ReloadHandlersCmd;
import tigase.http.rest.RestExtServlet;
import tigase.http.rest.RestServlet;
import tigase.http.util.StaticFileServlet;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticHolderImpl;
import tigase.stats.StatisticsList;

public class RestModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(RestModule.class.getCanonicalName());
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/rest";
    private static final String SCRIPTS_DIR_KEY = "rest-scripts-dir";
    private static final String NAME = "rest";
    private final ReloadHandlersCmd reloadHandlersCmd = new ReloadHandlersCmd(this);
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String scriptsDir = "scripts/rest";
    private String[] vhosts = null;
    private List<RestServlet> restServlets = new ArrayList<RestServlet>();
    private static final ConcurrentHashMap<String, StatisticHolder> stats = new ConcurrentHashMap();

    @Override
    public void everyHour() {
        for (StatisticHolder holder : stats.values()) {
            holder.everyHour();
        }
    }

    @Override
    public void everyMinute() {
        for (StatisticHolder holder : stats.values()) {
            holder.everyMinute();
        }
    }

    @Override
    public void everySecond() {
        for (StatisticHolder holder : stats.values()) {
            holder.everySecond();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "REST support - handles HTTP REST access using scripts";
    }

    @Override
    public void start() {
        ServletInfo servletInfo;
        File scriptsDirFile;
        File[] scriptDirFiles;
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(new ServiceImpl<RestModule>(this)).setDeploymentName("REST API").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        if ((scriptDirFiles = (scriptsDirFile = new File(this.scriptsDir)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"static".equals(file.getName());
            }
        })) != null) {
            File[] fileArray = scriptDirFiles;
            int n = scriptDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                try {
                    this.startRestServletForDirectory(this.httpDeployment, dirFile);
                }
                catch (IOException ex) {
                    log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
                }
                ++n2;
            }
        }
        try {
            servletInfo = HttpServer.servlet("RestServlet", RestExtServlet.class);
            servletInfo.addInitParam(RestServlet.REST_MODULE_KEY, this.uuid).addInitParam(RestServlet.SCRIPTS_DIR_KEY, scriptsDirFile.getCanonicalPath()).addMapping("/");
            this.httpDeployment.addServlets(servletInfo);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
        }
        servletInfo = HttpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File(scriptsDirFile, "static").getAbsolutePath()).addMapping("/static/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        this.restServlets = new ArrayList<RestServlet>();
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        props.put(SCRIPTS_DIR_KEY, DEF_SCRIPTS_DIR_VAL);
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey(SCRIPTS_DIR_KEY)) {
            this.scriptsDir = (String)props.get(SCRIPTS_DIR_KEY);
        }
        this.vhosts = (String[])props.get("vhosts");
        this.commandManager.registerCmd(this.reloadHandlersCmd);
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        for (StatisticHolder holder : stats.values()) {
            holder.getStatistics(compName, list);
        }
    }

    @Override
    public void executedIn(String path, long executionTime) {
        StatisticHolder holder = stats.get(path);
        if (holder == null) {
            StatisticHolderImpl tmp = new StatisticHolderImpl();
            tmp.setStatisticsPrefix(String.valueOf(this.getName()) + ", path=" + path);
            holder = stats.putIfAbsent(path, (StatisticHolder)tmp);
            if (holder == null) {
                holder = tmp;
            }
        }
        holder.statisticExecutedIn(executionTime);
    }

    @Override
    public void statisticExecutedIn(long executionTime) {
    }

    protected void registerRestServlet(RestServlet servlet) {
        this.restServlets.add(servlet);
    }

    protected List<? extends RestServlet> getRestServlets() {
        return this.restServlets;
    }

    private void startRestServletForDirectory(DeploymentInfo httpDeployment, File scriptsDirFile) throws IOException {
        File[] scriptFiles = RestModule.getGroovyFiles(scriptsDirFile);
        if (scriptFiles != null) {
            ServletInfo servletInfo = HttpServer.servlet("RestServlet", RestExtServlet.class);
            servletInfo.addInitParam(RestServlet.REST_MODULE_KEY, this.uuid).addInitParam(RestServlet.SCRIPTS_DIR_KEY, scriptsDirFile.getCanonicalPath()).addInitParam("mapping", "/" + scriptsDirFile.getName() + "/*").addMapping("/" + scriptsDirFile.getName() + "/*");
            httpDeployment.addServlets(servletInfo);
        }
    }

    public static File[] getGroovyFiles(File scriptsDirFile) {
        return scriptsDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith("groovy");
            }
        });
    }
}

