/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.admin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.admin.Servlet;
import tigase.http.util.StaticFileServlet;

public class AdminModule
extends AbstractModule {
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/admin";
    private static final String SCRIPTS_DIR_KEY = "admin-scripts-dir";
    private static final String NAME = "admin";
    private static final String DESCRIPTION = "Admin console - support for management of server using simple HTTP console";
    private String scriptsDir = "scripts/admin";
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String[] vhosts = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(new ServiceImpl<AdminModule>(this)).setDeploymentName("Admin console").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        File scriptsDirFile = new File(this.scriptsDir);
        scriptsDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"static".equals(file.getName());
            }
        });
        ServletInfo servletInfo = HttpServer.servlet("Servlet", Servlet.class);
        try {
            servletInfo.addInitParam("module-id-key", this.uuid).addInitParam("scripts-dir", scriptsDirFile.getCanonicalPath()).addMapping("/*");
        }
        catch (IOException ex) {
            Logger.getLogger(AdminModule.class.getName()).log(Level.WARNING, null, ex);
        }
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = HttpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File(scriptsDirFile, "static").getAbsolutePath()).addMapping("/static/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        props.put(SCRIPTS_DIR_KEY, DEF_SCRIPTS_DIR_VAL);
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey(SCRIPTS_DIR_KEY)) {
            this.scriptsDir = (String)props.get(SCRIPTS_DIR_KEY);
        }
        this.vhosts = (String[])props.get("vhosts");
    }
}

