/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.server;

import java.io.File;
import java.util.Map;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServletInfo;
import tigase.http.util.StaticFileServlet;

public class ServerInfoModule
extends AbstractModule {
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String[] vhosts = null;

    @Override
    public String getName() {
        return "server";
    }

    @Override
    public String getDescription() {
        return "Server information module";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath);
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = HttpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File("logs").getAbsolutePath()).addInitParam("index", "/server-info.html").addInitParam("allowed-pattern", "/server-info\\.html").addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        this.vhosts = (String[])props.get("vhosts");
    }
}

