/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.Service;
import tigase.http.java.DummyServletRequest;
import tigase.http.java.DummyServletResponse;

public class RequestHandler
implements HttpHandler {
    private final String contextPath;
    private final Map<String, HttpServlet> servlets = new ConcurrentHashMap<String, HttpServlet>();
    private final Service service;

    public RequestHandler(DeploymentInfo info) {
        ServletInfo[] servletInfos;
        this.contextPath = info.getContextPath();
        this.service = info.getService();
        ServletInfo[] servletInfoArray = servletInfos = info.getServlets();
        int n = servletInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ServletInfo servletInfo = servletInfoArray[n2];
            this.registerServlet(servletInfo);
            ++n2;
        }
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        String path = he.getRequestURI().getPath();
        ArrayList<String> keys = new ArrayList<String>(this.servlets.keySet());
        for (String key : keys) {
            if (!path.startsWith(key)) continue;
            HttpServlet servlet = this.servlets.get(key);
            if (servlet == null) break;
            try {
                String servletPath = key.substring(this.contextPath.length(), key.length() - 1);
                DummyServletRequest req = new DummyServletRequest(he, this.contextPath, servletPath, this.service);
                DummyServletResponse resp = new DummyServletResponse(he);
                servlet.service((ServletRequest)req, (ServletResponse)resp);
                AsyncContext async = req.getAsyncContext();
                if (async != null) break;
                resp.flushBuffer();
                he.getResponseBody().close();
            }
            catch (ServletException ex) {
                Logger.getLogger(RequestHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            break;
        }
    }

    private void registerServlet(ServletInfo info) {
        try {
            HttpServlet servlet = info.getServletClass().newInstance();
            ServletCfg cfg = new ServletCfg(info.getInitParams());
            servlet.init((ServletConfig)cfg);
            for (String mapping : info.getMappings()) {
                this.servlets.put(String.valueOf(this.contextPath) + mapping.replace("/*", "/"), servlet);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(RequestHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class ServletCfg
    implements ServletConfig {
        private final Map<String, String> params = new HashMap<String, String>();

        public ServletCfg(Map<String, String> map) {
            this.params.putAll(map);
        }

        public String getServletName() {
            return null;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String string) {
            return this.params.get(string);
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }
    }
}

