/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class DummyServletResponse
implements HttpServletResponse {
    private final HttpExchange exchange;
    private PrintWriter writer;

    public DummyServletResponse(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public String getContentType() {
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                if (DummyServletResponse.this.exchange.getResponseCode() == -1) {
                    DummyServletResponse.this.exchange.sendResponseHeaders(200, 0L);
                }
                DummyServletResponse.this.exchange.getResponseBody().write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener wl) {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.exchange.getResponseCode() == -1) {
                this.exchange.sendResponseHeaders(200, 0L);
            }
            this.writer = new PrintWriter(this.exchange.getResponseBody());
        }
        return this.writer;
    }

    public void setCharacterEncoding(String string) {
    }

    public void setContentLength(int i) {
        this.exchange.getResponseHeaders().set("Content-Length", String.valueOf(i));
    }

    public void setContentType(String string) {
        this.exchange.getResponseHeaders().set("Content-Type", string);
    }

    public void setBufferSize(int i) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.exchange.getResponseBody().flush();
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String string) {
        return false;
    }

    public String encodeURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String encodeRedirectURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String encodeRedirectUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void sendError(int i, String string) throws IOException {
        if (string != null) {
            this.exchange.sendResponseHeaders(i, string.getBytes().length);
            PrintWriter writer = this.getWriter();
            writer.write(string);
            writer.flush();
        } else {
            this.exchange.sendResponseHeaders(i, 0L);
        }
    }

    public void sendError(int i) throws IOException {
        this.exchange.sendResponseHeaders(i, 0L);
    }

    public void sendRedirect(String string) throws IOException {
        this.exchange.sendResponseHeaders(302, 0L);
    }

    public void setDateHeader(String string, long l) {
    }

    public void addDateHeader(String string, long l) {
    }

    public void setHeader(String string, String string1) {
        this.exchange.getResponseHeaders().set(string, string1);
    }

    public void addHeader(String string, String string1) {
        this.exchange.getResponseHeaders().add(string, string1);
    }

    public void setIntHeader(String string, int i) {
    }

    public void addIntHeader(String string, int i) {
    }

    public void setStatus(int i) {
        try {
            this.exchange.sendResponseHeaders(i, 0L);
        }
        catch (IOException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setStatus(int i, String string) {
        try {
            this.exchange.sendResponseHeaders(i, 0L);
        }
        catch (IOException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getStatus() {
        return 200;
    }

    public String getHeader(String string) {
        return this.exchange.getResponseHeaders().getFirst(string);
    }

    public Collection<String> getHeaders(String string) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public void setContentLengthLong(long l) {
        this.setHeader("Content-Length", String.valueOf(l));
    }
}

