/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.rest;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import tigase.db.DBInitException;
import tigase.db.comp.UserRepoRepository;
import tigase.http.rest.ApiKeyItem;
import tigase.xmpp.BareJID;

public class ApiKeyRepository
extends UserRepoRepository<ApiKeyItem> {
    private static final String GEN_API_KEYS = "--api-keys";
    public static final String API_KEYS_KEY = "api-keys";
    private boolean openAccess = false;
    private BareJID repoUserJid;

    public BareJID getRepoUser() {
        return this.repoUserJid;
    }

    public void setRepoUser(BareJID repoUserJid) {
        this.repoUserJid = repoUserJid;
    }

    public String getConfigKey() {
        return API_KEYS_KEY;
    }

    public String[] getDefaultPropetyItems() {
        return new String[0];
    }

    public String getItemsListPKey() {
        return API_KEYS_KEY;
    }

    public String getPropertyKey() {
        return GEN_API_KEYS;
    }

    public ApiKeyItem getItemInstance() {
        return new ApiKeyItem();
    }

    protected void initItemsMap() {
        this.items = new ConcurrentSkipListMap();
    }

    public boolean isAllowed(String key, String domain, String path) {
        if (this.openAccess) {
            return true;
        }
        if (key == null) {
            return false;
        }
        ApiKeyItem item = (ApiKeyItem)this.getItem(key);
        if (item == null) {
            return false;
        }
        return item.isAllowed(key, domain, path);
    }

    public void setProperties(Map<String, Object> props) {
        String[] items_arr = (String[])props.get(this.getConfigKey());
        this.openAccess = items_arr != null && items_arr.length == 1 && "open_access".equals(items_arr[0]);
        super.setProperties(props);
    }

    public void destroy() {
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }
}

