/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.DeploymentInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.java.RequestHandler;

public class JavaStandaloneHttpServer
implements HttpServerIfc {
    private HttpServer server = null;
    private int port = 8080;
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();

    @Override
    public void start() {
        if (this.server == null) {
            try {
                this.server = HttpServer.create(new InetSocketAddress(this.port), 100);
                this.server.start();
                this.deploy(Collections.unmodifiableList(this.deployments));
            }
            catch (IOException ex) {
                Logger.getLogger(JavaStandaloneHttpServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.undeploy(Collections.unmodifiableList(this.deployments));
            this.server.stop(1);
            this.server = null;
        }
    }

    @Override
    public void deploy(DeploymentInfo deployment) {
        this.deployments.add(deployment);
        if (this.server != null) {
            this.deploy(Collections.singletonList(deployment));
        }
    }

    @Override
    public void undeploy(DeploymentInfo deployment) {
        this.deployments.remove(deployment);
        if (this.server != null) {
            this.undeploy(Collections.singletonList(deployment));
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("port")) {
            this.port = (Integer)props.get("port");
        }
    }

    private void deploy(List<DeploymentInfo> toDeploy) {
        for (DeploymentInfo info : toDeploy) {
            this.server.createContext(info.getContextPath(), new RequestHandler(info));
        }
    }

    private void undeploy(List<DeploymentInfo> toUndeploy) {
        for (DeploymentInfo info : toUndeploy) {
            this.server.removeContext(info.getContextPath());
        }
    }
}

