/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.http.CommandManager;
import tigase.http.Module;
import tigase.http.PacketWriter;
import tigase.http.rest.ApiKeyRepository;
import tigase.server.Packet;
import tigase.server.script.CommandIfc;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class AbstractModule
implements Module {
    private JID jid;
    private PacketWriter writer;
    private ServiceEntity serviceEntity = null;
    private ApiKeyRepository apiKeyRepository = null;
    protected CommandManager commandManager = new CommandManager(this);

    @Override
    public boolean addOutPacket(Packet packet) {
        return this.writer.write(this, packet);
    }

    @Override
    public boolean addOutPacket(Packet packet, Integer timeout, PacketWriter.Callback callback) {
        return this.writer.write(this, packet, timeout, callback);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/commands"};
    }

    @Override
    public boolean processPacket(Packet packet) {
        if (packet.isCommand()) {
            return this.commandManager.execute(packet);
        }
        return false;
    }

    @Override
    public Element getDiscoInfo(String node, boolean isAdmin) {
        return this.serviceEntity.getDiscoInfo(node, isAdmin);
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (jid.getLocalpart() == null) {
            return Collections.singletonList(this.serviceEntity.getDiscoItem(node, String.valueOf(this.getName()) + "@" + jid.toString()));
        }
        if (node != null && node.equals("http://jabber.org/protocol/commands") && this.isAdmin(from.getBareJID())) {
            LinkedList<Element> result = new LinkedList<Element>();
            for (CommandIfc comm : this.commandManager.getCommands()) {
                result.add(new Element("item", new String[]{"node", "name", "jid"}, new String[]{comm.getCommandId(), comm.getDescription(), jid.toString()}));
            }
            return result;
        }
        return this.serviceEntity.getItems(node, jid.toString());
    }

    @Override
    public Map<String, Object> getDefaults() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("active", true);
        return props;
    }

    @Override
    public JID getJid() {
        return this.jid;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.serviceEntity = new ServiceEntity(this.getName(), null, this.getDescription(), true);
        this.serviceEntity.setFeatures(this.getFeatures());
        if (this.apiKeyRepository == null) {
            this.apiKeyRepository = new ApiKeyRepository();
        }
        this.apiKeyRepository.setRepoUser(BareJID.bareJIDInstanceNS((String)this.getName(), (String)((String)props.get("componentName"))));
        this.apiKeyRepository.setProperties(props);
    }

    @Override
    public void init(JID jid, PacketWriter writer) {
        this.jid = JID.jidInstanceNS((String)this.getName(), (String)jid.getDomain(), null);
        this.writer = writer;
    }

    @Override
    public void initBindings(Bindings binds) {
        binds.put("module", (Object)this);
    }

    @Override
    public boolean isAdmin(BareJID user) {
        return this.writer.isAdmin(JID.jidInstance((BareJID)user));
    }

    @Override
    public boolean isRequestAllowed(String key, String domain, String path) {
        return this.apiKeyRepository.isAllowed(key, domain, path);
    }

    @Override
    public UserRepository getUserRepository() {
        return this.writer.getUserRepository();
    }

    @Override
    public AuthRepository getAuthRepository() {
        return this.writer.getAuthRepository();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.apiKeyRepository.setAutoloadTimer(0L);
    }
}

