/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import tigase.http.DeploymentInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.jetty.Activator;
import tigase.http.jetty.JettyHttpServerHelper;
import tigase.kernel.core.Kernel;

public class JettyOSGiHttpServer
implements HttpServerIfc {
    private static final Logger log = Logger.getLogger(JettyOSGiHttpServer.class.getCanonicalName());
    private final BundleContext context;
    private final ConcurrentHashMap<String, ServiceRegistration> registeredContexts = new ConcurrentHashMap();
    private List<DeploymentInfo> deploymentInfos = new CopyOnWriteArrayList<DeploymentInfo>();

    public JettyOSGiHttpServer() {
        this.context = Activator.getContext();
    }

    public List<Integer> getHTTPPorts() {
        return null;
    }

    public List<Integer> getHTTPSPorts() {
        return null;
    }

    public void register(Kernel kernel) {
    }

    public void unregister(Kernel kernel) {
    }

    public List<DeploymentInfo> listDeployed() {
        return Collections.unmodifiableList(this.deploymentInfos);
    }

    public void deploy(DeploymentInfo deployment) {
        ServletContextHandler context = JettyHttpServerHelper.createServletContextHandler(deployment);
        this.deploy(context);
        deployment.put("context-key", (Object)context);
        this.deploymentInfos.add(deployment);
    }

    public void undeploy(DeploymentInfo deployment) {
        ServletContextHandler context = (ServletContextHandler)deployment.get("context-key");
        if (context != null) {
            this.undeploy(context);
        }
        this.deploymentInfos.remove(deployment);
    }

    protected void deploy(ServletContextHandler ctx) {
        String contextPath = ctx.getContextPath();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("contextFilePath", "/etc/tigase-http-context.xml");
        ServiceRegistration registration = this.context.registerService(ContextHandler.class.getName(), (Object)ctx, props);
        if (registration == null) {
            log.log(Level.SEVERE, "registration failed for {0}", contextPath);
        }
        this.registeredContexts.put(contextPath, registration);
    }

    protected void undeploy(ServletContextHandler ctx) {
        String contextPath = ctx.getContextPath();
        try {
            ServiceRegistration registration = this.registeredContexts.get(contextPath);
            if (registration != null) {
                registration.unregister();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "exception during unregistration of context = " + contextPath, ctx);
        }
    }
}

