/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import tigase.io.SSLContextContainerIfc;

public class PEMSSLContextContainer
implements SSLContextContainerIfc {
    private static final String KEY_MANAGER_ALGORITHM = "SunX509";
    private static final String KEY_STORE_ALGORITHM = "JKS";
    protected static final Logger log = Logger.getLogger(PEMSSLContextContainer.class.getName());
    public static final String PEM_PRIVATE_PWD_KEY = "pem-privatekey-password";
    public static final String PEM_PRIVATE_PWD_VAL = "";
    private static final String TRUST_MANAGER_ALGORITHM = "X509";
    private String caCertsPath = "";
    private String defaultHostname = "default";
    private String domainKeysPath = "";
    private String internalKeystorePassword = "";
    private String privateKeyPassphrase = "";
    private Map<String, SSLContext> sslContexts = new HashMap<String, SSLContext>();
    private TrustModel trustModel = TrustModel.all;
    private KeyStore trustKeyStore;
    private TrustManagerFactory trustManagerFactory;

    public PEMSSLContextContainer() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static void main(String[] args) throws Exception {
        System.out.println(".");
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMSSLContextContainer x = new PEMSSLContextContainer();
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("ssl-certs-location", "./");
        p.put("allow-self-signed-certs", "true");
        x.init(p);
        SSLContext ctx = x.getSSLContext("tls", "malkowscy.net");
        Socket socket = ctx.getSocketFactory().createSocket("www.mbank.com.pl", 443);
        try {
            String line;
            String data = URLEncoder.encode("key1", "UTF-8") + "=" + URLEncoder.encode("value1", "UTF-8");
            data = data + "&" + URLEncoder.encode("key2", "UTF-8") + "=" + URLEncoder.encode("value2", "UTF-8");
            String path = "/";
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            wr.write("POST " + path + " HTTP/1.0\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("\r\n");
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = rd.readLine()) != null) {
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCertificates(Map<String, String> params) {
        this.sslContexts.clear();
    }

    public SSLContext getSSLContext(String protocol, String hostname) {
        if (hostname == null) {
            hostname = this.defaultHostname;
        }
        try {
            String map_key = hostname + ":" + protocol;
            SSLContext sslContext = this.sslContexts.get(map_key);
            if (sslContext == null) {
                TrustManager[] trustManagers;
                sslContext = SSLContext.getInstance(protocol);
                switch (this.trustModel) {
                    case all: {
                        trustManagers = new TrustManager[]{new DummyTrustManager()};
                        log.fine("Creating SSLConext for " + protocol + ":" + hostname + " with trust everyone model.");
                        break;
                    }
                    case selfsigned: {
                        trustManagers = new TrustManager[]{new SelfSignedTrustManager(this.trustKeyStore)};
                        log.fine("Creating SSLConext for " + protocol + ":" + hostname + " all valid pathes model.");
                        break;
                    }
                    case trusted: {
                        trustManagers = this.trustManagerFactory.getTrustManagers();
                        log.fine("Creating SSLConext for " + protocol + ":" + hostname + " trusted CA based model.");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown trust model: " + (Object)((Object)this.trustModel));
                    }
                }
                File[] path = new File[]{new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".pem"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".key"), new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + hostname + ".cer")};
                KeyStore keyStore = this.loadFromPEMFile(path, hostname, this.privateKeyPassphrase);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEY_MANAGER_ALGORITHM);
                kmf.init(keyStore, this.privateKeyPassphrase.toCharArray());
                sslContext.init(kmf.getKeyManagers(), trustManagers, new SecureRandom());
                this.sslContexts.put(map_key, sslContext);
            }
            return sslContext;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error on creating SSLContext for host " + hostname, e);
            return null;
        }
    }

    public KeyStore getTrustStore() {
        return this.trustKeyStore;
    }

    public void init(Map<String, Object> params) {
        this.caCertsPath = this.getFromMap(params, "trusted-certs-dir", "/etc/ssl/certs");
        boolean allowInvalidCerts = Boolean.getBoolean(this.getFromMap(params, "allow-invalid-certs", "false"));
        boolean allowSelfSignedCerts = "true".equals(this.getFromMap(params, "allow-self-signed-certs", "true"));
        this.trustModel = allowInvalidCerts ? TrustModel.all : (allowSelfSignedCerts ? TrustModel.selfsigned : TrustModel.trusted);
        this.domainKeysPath = this.getFromMap(params, "ssl-certs-location", "certs/");
        this.privateKeyPassphrase = this.getFromMap(params, PEM_PRIVATE_PWD_KEY, PEM_PRIVATE_PWD_VAL);
        this.defaultHostname = this.getFromMap(params, "ssl-def-cert-domain", "default");
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error on initialization", e);
        }
    }

    private String getFromMap(Map<String, Object> params, String key, String defaultVal) {
        if (params.containsKey(key)) {
            return (String)params.get(key);
        }
        params.put(key, defaultVal);
        return defaultVal;
    }

    private void init() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidAlgorithmParameterException {
        File root = new File(this.caCertsPath);
        File[] files = root.listFiles();
        this.trustKeyStore = KeyStore.getInstance(KEY_STORE_ALGORITHM);
        this.trustKeyStore.load(null, this.internalKeystorePassword.toCharArray());
        log.config("Initializing SSL Context Container with trust model = " + this.trustModel.name());
        log.info("Loading trusted CA certificates from " + root.getAbsolutePath() + "...");
        if (files != null) {
            for (File file : files) {
                try {
                    List<Object> objs = this.readObjectsFromFile(file, null);
                    for (Object object : objs) {
                        if (!(object instanceof X509Certificate)) continue;
                        X509Certificate crt = (X509Certificate)object;
                        String alias = crt.getSubjectDN().getName();
                        this.trustKeyStore.setCertificateEntry(alias, crt);
                        log.finest("Imported cert: " + crt.getSubjectDN().getName());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        log.info("Loaded " + this.trustKeyStore.size() + " trusted CA certificates.");
        this.trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_ALGORITHM);
        X509CertSelector selector = new X509CertSelector();
        PKIXBuilderParameters cpp = new PKIXBuilderParameters(this.trustKeyStore, (CertSelector)selector);
        cpp.setRevocationEnabled(false);
        CertPathTrustManagerParameters p = new CertPathTrustManagerParameters(cpp);
        this.trustManagerFactory.init(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadFromPEMFile(File[] fileNames, String alias, final String privateKeyPassphrase) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        PasswordFinder x = new PasswordFinder(){

            public char[] getPassword() {
                if (privateKeyPassphrase != null) {
                    return privateKeyPassphrase.toCharArray();
                }
                return null;
            }
        };
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        Key key = null;
        log.info("Reading private key & certificate chain; alias: '" + alias + "', password: '" + privateKeyPassphrase + "'");
        for (File fileName : fileNames) {
            if (!fileName.exists()) continue;
            log.info("Reading data from file " + fileName);
            PEMReader reader = null;
            try {
                reader = new PEMReader((Reader)new FileReader(fileName), x);
                Object pemObject = null;
                while ((pemObject = reader.readObject()) != null) {
                    if (pemObject instanceof Certificate) {
                        certs.add((Certificate)pemObject);
                        continue;
                    }
                    if (pemObject instanceof KeyPair) {
                        key = ((KeyPair)pemObject).getPrivate();
                        continue;
                    }
                    if (!(pemObject instanceof Key)) continue;
                    key = (Key)pemObject;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        if (certs.size() > 0) {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_ALGORITHM);
            keyStore.load(null, this.internalKeystorePassword.toCharArray());
            keyStore.setKeyEntry(alias, key, this.internalKeystorePassword.toCharArray(), certs.toArray(new Certificate[0]));
            return keyStore;
        }
        return this.loadFromPEMFile(new File[]{new File(new File(this.domainKeysPath).getAbsoluteFile() + File.separator + "default.pem")}, alias, privateKeyPassphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readObjectsFromFile(File file, final String password) throws IOException {
        PEMReader reader = null;
        PasswordFinder pfinder = new PasswordFinder(){

            public char[] getPassword() {
                if (password != null) {
                    return password.toCharArray();
                }
                return null;
            }
        };
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            reader = new PEMReader((Reader)new FileReader(file), pfinder);
            Object pemObject = null;
            while ((pemObject = reader.readObject()) != null) {
                result.add(pemObject);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static class SelfSignedTrustManager
    implements X509TrustManager {
        private CertPathValidator certPathValidator;
        private KeyStore localTrustKeystore;
        private X509Certificate root;

        public SelfSignedTrustManager(KeyStore trustKeystore) {
            try {
                this.localTrustKeystore = KeyStore.getInstance(PEMSSLContextContainer.KEY_STORE_ALGORITHM);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                trustKeystore.store(out, PEMSSLContextContainer.PEM_PRIVATE_PWD_VAL.toCharArray());
                this.localTrustKeystore.load(new ByteArrayInputStream(out.toByteArray()), PEMSSLContextContainer.PEM_PRIVATE_PWD_VAL.toCharArray());
                this.certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error on construct TrustManager", e);
                throw new RuntimeException("Error on construct TrustManager", e);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate certificate : chain) {
                if (!((Object)certificate.getIssuerDN()).equals(certificate.getSubjectDN())) continue;
                this.root = certificate;
                break;
            }
            try {
                this.localTrustKeystore.setCertificateEntry("root", this.root);
                X509CertSelector selector = new X509CertSelector();
                PKIXBuilderParameters params = new PKIXBuilderParameters(this.localTrustKeystore, (CertSelector)selector);
                params.setRevocationEnabled(false);
                List<X509Certificate> certList = Arrays.asList(chain);
                CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certList);
                this.certPathValidator.validate(certPath, params);
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[]{this.root};
        }
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static enum TrustModel {
        all,
        selfsigned,
        trusted;

    }
}

