/*
 * Decompiled with CFR 0.152.
 */
package tigase.management;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jndi.rmi.registry.RegistryContextFactory;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.snmp.IPAcl.JdmkAcl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import tigase.conf.MonitoringSetupIfc;

public class MonitoringSetup
implements MonitoringSetupIfc {
    private static final Logger log = Logger.getLogger(MonitoringSetup.class.getName());
    private SnmpAdaptorServer snmpadaptor = null;
    private static LinkedHashMap<String, Object> mxbeans = new LinkedHashMap();

    public void initMonitoring(String monitoring, String configDir) {
        String[] monitors;
        if (monitoring == null) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        log.config("Installing monitoring services: " + monitoring);
        for (String string : monitors = monitoring.split(",")) {
            try {
                String[] mon = string.split(":");
                MonitoringSetupIfc.MONITOR monitor = MonitoringSetupIfc.MONITOR.valueOf((String)mon[0]);
                int port = Integer.parseInt(mon[1]);
                switch (monitor) {
                    case jmx: {
                        log.config("Loading JMX monitor.");
                        LocateRegistry.createRegistry(port);
                        String serviceURL = "service:jmx:rmi:///jndi/rmi://localhost:" + mon[1] + "/jmxrmi" + "";
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        map.put("java.naming.factory.initial", RegistryContextFactory.class.getName());
                        map.put("jmx.remote.jndi.rebind", "true");
                        map.put("jmx.remote.x.password.file", configDir + File.separator + "jmx.password");
                        map.put("jmx.remote.x.access.file", configDir + File.separator + "jmx.access");
                        JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceURL), map, server);
                        server.registerMBean(connector, new ObjectName("system:name=rmiconnector"));
                        connector.start();
                        break;
                    }
                    case http: {
                        log.config("Loading HTTP monitor.");
                        HtmlAdaptorServer adaptor = new HtmlAdaptorServer();
                        ObjectName httpName = new ObjectName("localhost:class=HtmlAdaptorServer,protocol=html,port=" + port);
                        server.registerMBean(adaptor, httpName);
                        adaptor.setPort(port);
                        adaptor.start();
                        break;
                    }
                    case snmp: {
                        log.config("Loading SNMP monitor.");
                        ObjectName snmpName = new ObjectName("localhost:class=SnmpAdaptorServer,protocol=snmp,port=" + port);
                        JdmkAcl acl = new JdmkAcl("tigase", configDir + File.separator + "snmp.acl");
                        this.snmpadaptor = new SnmpAdaptorServer((InetAddressAcl)acl, port);
                        server.registerMBean(this.snmpadaptor, snmpName);
                        this.snmpadaptor.start();
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not start the monitor: " + string + ": ", e);
            }
        }
    }

    public void initializationCompleted() {
        log.config("initializationCompleted.");
        if (this.snmpadaptor != null) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                String className = "tigase.management.TIGASE_MANAGEMENT_MIB";
                String objName = "snmp:class=TIGASE_MANAGEMENT_MIB";
                log.config("Initializing Tiase MIB MXBean");
                ObjectName mibObjName = new ObjectName(objName);
                SnmpMib mib = (SnmpMib)Class.forName(className).newInstance();
                server.registerMBean(mib, mibObjName);
                this.snmpadaptor.addMib((SnmpMibAgent)mib);
                this.putMXBean(objName, mib);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not load Tigase monitoring MXBean: ", e);
            }
        } else {
            log.config("snmpadaptor not installed, skipping MIB loading.");
        }
    }

    public void putMXBean(String objName, Object bean) {
        mxbeans.put(objName, bean);
    }

    public Object getMXBean(String objName) {
        return mxbeans.get(objName);
    }
}

