/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.gateway;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnMessageListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.impl.MsnMessengerFactory;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;
import tigase.server.Packet;
import tigase.server.gateways.GatewayConnection;
import tigase.server.gateways.GatewayException;
import tigase.server.gateways.GatewayListener;
import tigase.server.gateways.RosterItem;
import tigase.server.gateways.UserStatus;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;

public class MsnConnection
implements MsnContactListListener,
GatewayConnection,
MsnMessengerListener,
MsnMessageListener {
    private static Logger log = Logger.getLogger("tigase.extras.gateway.MsnConnection");
    private String username = null;
    private String password = null;
    private MsnMessenger messenger = null;
    private GatewayListener listener = null;
    private Set<String> xmpp_jids = new HashSet<String>();
    private String active_jid = null;

    public void setLogin(String username, String password) {
        this.username = username;
        this.password = password;
        log.finest("Username, password set: (" + username + "," + password + ")");
    }

    public void addJid(String jid) {
        this.xmpp_jids.add(jid);
        this.active_jid = jid;
        log.finest("JID added: " + jid);
    }

    public void removeJid(String jid) {
        this.xmpp_jids.remove(jid);
        log.finest("JID removed: " + jid);
    }

    public String[] getAllJids() {
        return this.xmpp_jids.toArray(new String[this.xmpp_jids.size()]);
    }

    public void setGatewayListener(GatewayListener listener) {
        this.listener = listener;
    }

    public void init() throws GatewayException {
        this.messenger = MsnMessengerFactory.createMsnMessenger((String)this.username, (String)this.password);
        this.messenger.addMessageListener((MsnMessageListener)this);
        this.messenger.addMessengerListener((MsnMessengerListener)this);
        this.messenger.addContactListListener((MsnContactListListener)this);
    }

    public void login() {
        this.messenger.login();
    }

    public void logout() {
        this.messenger.logout();
    }

    public void sendMessage(Packet packet) {
        String address = this.listener.decodeLegacyName(packet.getElemTo());
        this.active_jid = packet.getElemFrom();
        if (packet.getElemName().equals("message")) {
            log.finest("Sending message: " + packet.toString());
            String body = XMLUtils.unescape((String)packet.getElemCData("/message/body"));
            this.messenger.sendText(Email.parseStr((String)address), body);
        } else {
            log.finest("Ignoring unknown packet: " + packet.toString());
        }
    }

    public void instantMessageReceived(MsnSwitchboard msnSwitchboard, MsnInstantMessage msnInstantMessage, MsnContact msnContact) {
        String to = this.active_jid;
        String from = this.listener.formatJID(msnContact.getEmail().getEmailAddress());
        String content = XMLUtils.escape((String)msnInstantMessage.getContent());
        Element message = new Element("message", new String[]{"from", "to", "type"}, new String[]{from, to, "chat"});
        Element body = new Element("body", content);
        message.addChild((XMLNodeIfc)body);
        Packet packet = new Packet(message);
        log.finest("Received instant message: " + packet.toString());
        this.listener.packetReceived(packet);
    }

    public void controlMessageReceived(MsnSwitchboard msnSwitchboard, MsnControlMessage msnControlMessage, MsnContact msnContact) {
        String to = this.active_jid;
        String from = this.listener.formatJID(msnContact.getEmail().getEmailAddress());
        Element message = new Element("message", new String[]{"from", "to", "type"}, new String[]{from, to, "chat"});
        Element composing = new Element("composing");
        composing.setXMLNS("http://jabber.org/protocol/chatstates");
        message.addChild((XMLNodeIfc)composing);
        Packet packet = new Packet(message);
        log.finest("Received control message: " + packet.toString());
        this.listener.packetReceived(packet);
    }

    public void systemMessageReceived(MsnMessenger msnMessenger, MsnSystemMessage msnSystemMessage) {
    }

    public void datacastMessageReceived(MsnSwitchboard msnSwitchboard, MsnDatacastMessage msnDatacastMessage, MsnContact msnContact) {
    }

    public void unknownMessageReceived(MsnSwitchboard msnSwitchboard, MsnUnknownMessage msnUnknownMessage, MsnContact msnContact) {
    }

    public void p2pMessageReceived(MsnSwitchboard switchboard, MsnP2PMessage message, MsnContact contact) {
    }

    public void logout(MsnMessenger msnMessenger) {
        this.listener.logout((GatewayConnection)this);
        log.finest(this.active_jid + " logout called.");
    }

    public void loginCompleted(MsnMessenger msnMessenger) {
        this.listener.loginCompleted((GatewayConnection)this);
        log.finest(this.active_jid + " logout completed.");
        MsnOwner owner = msnMessenger.getOwner();
        log.fine("Owner initstatus: " + owner.getInitStatus().getDisplayStatus());
        log.fine("Owner isNotifyMeWhenSomeoneAddedMe: " + owner.isNotifyMeWhenSomeoneAddedMe());
        log.fine("Owner isOnlyNotifyAllowList: " + owner.isOnlyNotifyAllowList());
        owner.setNotifyMeWhenSomeoneAddedMe(true);
        owner.setInitStatus(MsnUserStatus.ONLINE);
        owner.setStatus(MsnUserStatus.ONLINE);
    }

    public void exceptionCaught(MsnMessenger msnMessenger, Throwable throwable) {
        this.listener.gatewayException((GatewayConnection)this, throwable);
    }

    public void contactListSyncCompleted(MsnMessenger msnMessenger) {
        log.finest(this.active_jid + " contactListSyncCompleted completed.");
        this.listener.userRoster((GatewayConnection)this);
    }

    public List<RosterItem> getRoster() {
        return this.getRoster(this.messenger, null);
    }

    private List<RosterItem> getRoster(MsnMessenger msnMessenger, MsnUserStatus presetStatus) {
        MsnContact[] list = msnMessenger.getContactList().getContacts();
        ArrayList<RosterItem> roster = new ArrayList<RosterItem>();
        if (list != null) {
            for (MsnContact contact : list) {
                if (contact.isInList(MsnList.AL)) {
                    MsnUserStatus status;
                    MsnGroup[] c_groups = contact.getBelongGroups();
                    if (c_groups != null && c_groups.length > 0) {
                        for (MsnGroup c_grp : c_groups) {
                            log.fine("Contact " + contact.getEmail().getEmailAddress() + " group: " + c_grp.getGroupName());
                        }
                    } else {
                        log.fine("Contact " + contact.getEmail().getEmailAddress() + " is not in any group, status: " + contact.getStatus().getDisplayStatus());
                    }
                    MsnContactList c_list = contact.getContactList();
                    RosterItem item = new RosterItem(contact.getEmail().getEmailAddress());
                    item.setName(contact.getFriendlyName());
                    item.setSubscription("both");
                    MsnUserStatus msnUserStatus = status = presetStatus != null ? presetStatus : contact.getStatus();
                    if (status == MsnUserStatus.OFFLINE) {
                        item.setStatus(new UserStatus("unavailable", null));
                    } else {
                        item.setStatus(new UserStatus(null, status.getDisplayStatus().toLowerCase()));
                    }
                    MsnGroup[] groups = contact.getBelongGroups();
                    if (groups != null && groups.length > 0) {
                        ArrayList<String> grps = new ArrayList<String>();
                        for (MsnGroup group : groups) {
                            grps.add(group.getGroupName());
                        }
                        item.setGroups(grps);
                    }
                    log.finest("Contact AL received: " + contact.getEmail().getEmailAddress() + ", status: " + status.getDisplayStatus());
                    roster.add(item);
                }
                if (contact.isInList(MsnList.AL)) {
                    log.fine("Contact " + contact.getEmail().getEmailAddress() + " is on AL list.");
                }
                if (contact.isInList(MsnList.BL)) {
                    log.fine("Contact " + contact.getEmail().getEmailAddress() + " is on BL list.");
                }
                if (contact.isInList(MsnList.FL)) {
                    log.fine("Contact " + contact.getEmail().getEmailAddress() + " is on FL list.");
                }
                if (contact.isInList(MsnList.PL)) {
                    log.fine("Contact " + contact.getEmail().getEmailAddress() + " is on PL list.");
                }
                if (!contact.isInList(MsnList.RL)) continue;
                log.fine("Contact " + contact.getEmail().getEmailAddress() + " is on RL list.");
            }
        }
        return roster;
    }

    public void contactListInitCompleted(MsnMessenger msnMessenger) {
        log.finest(this.active_jid + " contactListInitCompleted completed.");
        this.listener.userRoster((GatewayConnection)this);
    }

    public void contactStatusChanged(MsnMessenger msnMessenger, MsnContact msnContact) {
        log.finest(this.active_jid + " contactStatusChanged completed.");
        if (msnContact.isInList(MsnList.AL)) {
            RosterItem item = new RosterItem(msnContact.getEmail().getEmailAddress());
            item.setName(msnContact.getFriendlyName());
            item.setSubscription("both");
            if (msnContact.getStatus() == MsnUserStatus.OFFLINE) {
                item.setStatus(new UserStatus("unavailable", null));
            } else {
                item.setStatus(new UserStatus(null, msnContact.getStatus().getDisplayStatus().toLowerCase()));
            }
            MsnGroup[] groups = msnContact.getBelongGroups();
            if (groups != null && groups.length > 0) {
                ArrayList<String> grps = new ArrayList<String>();
                for (MsnGroup group : groups) {
                    grps.add(group.getGroupName());
                }
                item.setGroups(grps);
            }
            this.listener.updateStatus((GatewayConnection)this, item);
        }
        if (msnContact.isInList(MsnList.AL)) {
            log.fine("Contact " + msnContact.getEmail().getEmailAddress() + " is on AL list.");
        }
        if (msnContact.isInList(MsnList.BL)) {
            log.fine("Contact " + msnContact.getEmail().getEmailAddress() + " is on BL list.");
        }
        if (msnContact.isInList(MsnList.FL)) {
            log.fine("Contact " + msnContact.getEmail().getEmailAddress() + " is on FL list.");
        }
        if (msnContact.isInList(MsnList.PL)) {
            log.fine("Contact " + msnContact.getEmail().getEmailAddress() + " is on PL list.");
        }
        if (msnContact.isInList(MsnList.RL)) {
            log.fine("Contact " + msnContact.getEmail().getEmailAddress() + " is on RL list.");
        }
    }

    public void ownerStatusChanged(MsnMessenger msnMessenger) {
        log.finest(this.active_jid + " ownerStatusChanged completed.");
    }

    public void contactAddedMe(MsnMessenger msnMessenger, MsnContact msnContact) {
        String to = this.active_jid;
        String from = this.listener.formatJID(msnContact.getEmail().getEmailAddress());
        Element presence = new Element("presence", new String[]{"from", "to", "type"}, new String[]{from, to, "subscribe"});
        Packet packet = new Packet(presence);
        log.finest("Received subscription presence: " + packet.toString());
        this.listener.packetReceived(packet);
        presence = new Element("presence", new String[]{"from", "to", "type"}, new String[]{from, to, "subscribed"});
        packet = new Packet(presence);
        log.finest("Received subscription presence: " + packet.toString());
        this.listener.packetReceived(packet);
        log.finest(this.active_jid + " contactAddedMe completed.");
    }

    public void contactRemovedMe(MsnMessenger msnMessenger, MsnContact msnContact) {
        String to = this.active_jid;
        String from = this.listener.formatJID(msnContact.getEmail().getEmailAddress());
        Element presence = new Element("presence", new String[]{"from", "to", "type"}, new String[]{from, to, "unsubscribe"});
        Packet packet = new Packet(presence);
        log.finest("Received subscription presence: " + packet.toString());
        this.listener.packetReceived(packet);
        presence = new Element("presence", new String[]{"from", "to", "type"}, new String[]{from, to, "unsubscribed"});
        packet = new Packet(presence);
        log.finest("Received subscription presence: " + packet.toString());
        this.listener.packetReceived(packet);
        log.finest(this.active_jid + " contactRemovedMe completed.");
    }

    public void contactAddCompleted(MsnMessenger msnMessenger, MsnContact msnContact) {
        RosterItem item = new RosterItem(msnContact.getEmail().getEmailAddress());
        item.setName(msnContact.getFriendlyName());
        item.setSubscription("both");
        if (msnContact.getStatus() == MsnUserStatus.OFFLINE) {
            item.setStatus(new UserStatus("unavailable", null));
        } else {
            item.setStatus(new UserStatus(null, msnContact.getStatus().getDisplayStatus().toLowerCase()));
        }
        MsnGroup[] groups = msnContact.getBelongGroups();
        if (groups != null && groups.length > 0) {
            ArrayList<String> grps = new ArrayList<String>();
            for (MsnGroup group : groups) {
                grps.add(group.getGroupName());
            }
            item.setGroups(grps);
        }
        this.listener.updateStatus((GatewayConnection)this, item);
        log.finest(this.active_jid + " contactAddCompleted completed.");
    }

    public void contactRemoveCompleted(MsnMessenger msnMessenger, MsnContact msnContact) {
        log.finest(this.active_jid + " contactRemoveCompleted completed: " + msnContact.getEmail().getEmailAddress());
    }

    public void groupAddCompleted(MsnMessenger msnMessenger, MsnGroup msnGroup) {
        log.finest(this.active_jid + " groupAddCompleted completed.");
    }

    public void groupRemoveCompleted(MsnMessenger msnMessenger, MsnGroup msnGroup) {
        log.finest(this.active_jid + " groupRemoveCompleted completed.");
    }

    public void addBuddy(String id, String nick) throws GatewayException {
        this.messenger.addFriend(Email.parseStr((String)id), nick);
        this.messenger.unblockFriend(Email.parseStr((String)id));
        log.finest(this.active_jid + " addBuddy completed: " + id);
    }

    public void removeBuddy(String id) throws GatewayException {
        this.messenger.removeFriend(Email.parseStr((String)id), false);
        log.finest(this.active_jid + " removeBuddy completed: " + id);
    }

    public String getType() {
        return "msn";
    }

    public String getName() {
        return "MSN Gateway";
    }

    public String getPromptMessage() {
        return "Please enter the Windows Live Messenger address of the person you would like to contact.";
    }
}

