/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.mongodb.push;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.push.Device;
import tigase.push.PushSettings;
import tigase.push.api.IPushSettings;
import tigase.push.repositories.AbstractPushRepository;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="push", name="Tigase Push Component")
public class MongoPushRepository
extends AbstractPushRepository<MongoDataSource> {
    private static final String HASH_ALG = "SHA-256";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String PUSH_DEVICES_COLLECTION = "tig_push_devices";
    private static final String SERVICE_JID = "service_jid";
    private static final String SERVICE_JID_ID = "service_jid_id";
    private static final String USER_JID = "user_jid";
    private static final String USER_JID_ID = "user_jid_id";
    private static final String NODE = "node";
    private static final String NODE_ID = "node_id";
    private static final String PROVIDER = "provider";
    private static final String DEVICE_ID = "device_id";
    private static final String DEVICE_ID_ID = "device_id_id";
    private MongoDatabase db;
    private MongoCollection<Document> pushDevicesCollection;

    private static byte[] calculateHash(BareJID user) throws TigaseDBException {
        return MongoPushRepository.calculateHash(user.toString().toLowerCase());
    }

    private static byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    public IPushSettings registerDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException {
        try {
            String node = this.calculateNode(serviceJid, userJid);
            byte[] serviceJidId = MongoPushRepository.calculateHash(serviceJid);
            byte[] nodeId = MongoPushRepository.calculateHash(node);
            Document doc = new Document(SERVICE_JID, (Object)serviceJid.toString()).append(SERVICE_JID_ID, (Object)serviceJidId).append(USER_JID, (Object)userJid.toString()).append(USER_JID_ID, (Object)MongoPushRepository.calculateHash(userJid)).append(NODE, (Object)node).append(NODE_ID, (Object)nodeId).append(PROVIDER, (Object)provider).append(DEVICE_ID, (Object)deviceId).append(DEVICE_ID_ID, (Object)MongoPushRepository.calculateHash(deviceId));
            this.pushDevicesCollection.insertOne((Object)doc);
            return this.getNodeSettings(serviceJid, node, serviceJidId, nodeId);
        }
        catch (Exception e) {
            throw new RepositoryException("Could not register device", (Throwable)e);
        }
    }

    public IPushSettings unregisterDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException, ComponentException {
        try {
            String node = this.calculateNode(serviceJid, userJid);
            byte[] serviceJidId = MongoPushRepository.calculateHash(serviceJid);
            byte[] nodeId = MongoPushRepository.calculateHash(node);
            IPushSettings pushSettings = this.getNodeSettings(serviceJid, node, serviceJidId, nodeId);
            if (pushSettings != null) {
                Device device = new Device(provider, deviceId);
                pushSettings = pushSettings.removeDevice((IPushSettings.IDevice)device);
            }
            if (pushSettings == null) {
                throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Device is not registered");
            }
            Document doc = new Document(SERVICE_JID_ID, (Object)serviceJidId).append(USER_JID_ID, (Object)MongoPushRepository.calculateHash(userJid)).append(NODE_ID, (Object)nodeId).append(PROVIDER, (Object)provider).append(DEVICE_ID_ID, (Object)MongoPushRepository.calculateHash(deviceId));
            this.pushDevicesCollection.deleteMany((Bson)doc);
            return pushSettings;
        }
        catch (ComponentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Could not unregister device", (Throwable)e);
        }
    }

    public IPushSettings getNodeSettings(BareJID serviceJid, String node) throws RepositoryException {
        try {
            byte[] serviceJidId = MongoPushRepository.calculateHash(serviceJid);
            byte[] nodeId = MongoPushRepository.calculateHash(node);
            return this.getNodeSettings(serviceJid, node, serviceJidId, nodeId);
        }
        catch (Exception e) {
            throw new RepositoryException("Could not retrieve setting by service jid and node", (Throwable)e);
        }
    }

    public Stream<IPushSettings> getNodeSettings(String provider, String deviceId) throws RepositoryException {
        try {
            ArrayList settings = new ArrayList();
            this.pushDevicesCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)PROVIDER, (Object)provider), Filters.eq((String)DEVICE_ID_ID, (Object)MongoPushRepository.calculateHash(deviceId))})).projection(Projections.include((String[])new String[]{SERVICE_JID, NODE, USER_JID, PROVIDER, DEVICE_ID})).forEach(doc -> {
                BareJID serviceJid = BareJID.bareJIDInstanceNS((String)doc.getString((Object)SERVICE_JID));
                BareJID ownerJid = BareJID.bareJIDInstanceNS((String)doc.getString((Object)USER_JID));
                String node = doc.getString((Object)NODE);
                IPushSettings entry = settings.stream().filter(it -> it.getServiceJid().equals((Object)serviceJid) && it.getOwenerJid().equals((Object)ownerJid) && it.getNode().equals(node)).findFirst().orElseGet(() -> new PushSettings(serviceJid, node, ownerJid, Collections.emptyList()));
                settings.remove(entry);
                settings.add(entry.addDevice((IPushSettings.IDevice)new Device(doc.getString((Object)PROVIDER), doc.getString((Object)DEVICE_ID))));
            });
            return settings.stream();
        }
        catch (Exception e) {
            throw new RepositoryException("Could not retrieve setting by service jid and node", (Throwable)e);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists((MongoDatabase)this.db, (String)PUSH_DEVICES_COLLECTION)) {
            this.db.createCollection(PUSH_DEVICES_COLLECTION);
        }
        this.pushDevicesCollection = this.db.getCollection(PUSH_DEVICES_COLLECTION);
        this.pushDevicesCollection.createIndex(Indexes.ascending((String[])new String[]{SERVICE_JID_ID, USER_JID_ID, PROVIDER, DEVICE_ID_ID}), new IndexOptions().unique(true));
        this.pushDevicesCollection.createIndex(Indexes.ascending((String[])new String[]{SERVICE_JID_ID, NODE_ID}));
        this.pushDevicesCollection.createIndex(Indexes.ascending((String[])new String[]{PROVIDER, DEVICE_ID_ID}));
    }

    private IPushSettings getNodeSettings(BareJID serviceJid, String node, byte[] serviceJidId, byte[] nodeId) {
        BareJID userJid = null;
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Document doc : this.pushDevicesCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)SERVICE_JID_ID, (Object)serviceJidId), Filters.eq((String)NODE_ID, (Object)nodeId)})).projection(Projections.include((String[])new String[]{USER_JID, PROVIDER, DEVICE_ID}))) {
            userJid = BareJID.bareJIDInstanceNS((String)doc.getString((Object)USER_JID));
            devices.add(new Device(doc.getString((Object)PROVIDER), doc.getString((Object)DEVICE_ID)));
        }
        if (userJid == null) {
            return null;
        }
        return new PushSettings(serviceJid, node, userJid, devices);
    }
}

