/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.mailer;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import tigase.extras.mailer.MailerException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.config.ConfigField;

@Bean(name="mailer", active=true, exportable=true)
public class Mailer
implements Initializable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @ConfigField(desc="Default sender address (field 'from'", alias="mailer-from-address")
    private String fromAddress;
    private Session session;
    @ConfigField(desc="SMTP host", alias="mailer-smtp-host")
    private String smtpHost;
    @ConfigField(desc="SMTP password", alias="mailer-smtp-password")
    private String smtpPassword;
    @ConfigField(desc="SMTP port", alias="mailer-smtp-port")
    private String smtpPort = "587";
    @ConfigField(desc="SMTP username", alias="mailer-smtp-username")
    private String smtpUsername;

    public void initialize() {
        this.log.config("Configuring Mailer...");
        Properties sessionProperties = new Properties();
        sessionProperties.put("mail.smtp.auth", "false");
        sessionProperties.put("mail.smtp.starttls.enable", "true");
        sessionProperties.put("mail.smtp.ssl.trust", "*");
        sessionProperties.put("mail.smtps.ssl.trust", "*");
        sessionProperties.put("mail.smtp.ssl.checkserveridentity", "false");
        sessionProperties.put("mail.smtp.ssl.trust", "*");
        sessionProperties.put("mail.smtp.starttls.checkserveridentity", "false");
        sessionProperties.put("mail.smtp.starttls.trust", "*");
        try {
            sessionProperties.put("mail.smtp.host", this.smtpHost);
            sessionProperties.put("mail.smtp.port", this.smtpPort);
            this.log.log(Level.CONFIG, "Setting username: {0}", this.smtpUsername);
            if (this.smtpPassword != null && !this.smtpPassword.isEmpty()) {
                this.log.log(Level.CONFIG, "Setting password: {0}", this.smtpPassword.replaceAll(".", "*"));
            }
            this.log.log(Level.CONFIG, "Setting default fromAddress: {0}", this.fromAddress);
            this.session = Session.getInstance((Properties)sessionProperties);
            this.log.log(Level.CONFIG, "Setting session: {0}", this.session);
        }
        catch (RuntimeException e) {
            this.log.warning(e.getMessage());
            this.log.warning("Mailer is not started");
            return;
        }
        this.log.config("Mailer is configured");
    }

    public void sendMail(String toAddresses, String messageSubject, String messageText) throws MailerException {
        this.sendMail(null, toAddresses, messageSubject, messageText);
    }

    public void sendMail(String from, String toAddresses, String messageSubject, String messageText) throws MailerException {
        try {
            this.log.fine("Sending mail: " + messageText);
            MimeMessage message = new MimeMessage(this.session);
            if (from == null) {
                message.setFrom((Address)new InternetAddress(this.fromAddress));
            } else {
                message.setFrom((Address)new InternetAddress(from));
            }
            InternetAddress[] to = InternetAddress.parse((String)toAddresses);
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
            message.setSubject(messageSubject);
            message.setText(messageText);
            if (this.smtpUsername == null || this.smtpUsername.trim().isEmpty()) {
                Transport.send((Message)message, (Address[])to);
            } else {
                Transport.send((Message)message, (Address[])to, (String)this.smtpUsername, (String)this.smtpPassword);
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Can't send mail", e);
            throw new MailerException(e);
        }
    }
}

