/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.mailer;

import com.sun.mail.smtp.SMTPAddressFailedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import tigase.extras.mailer.MailerException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.util.StringUtilities;

@Bean(name="mailer", active=true, exportable=true)
public class Mailer
implements Initializable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @ConfigField(desc="Default sender address (field 'from'", alias="mailer-from-address")
    private String fromAddress;
    private Session session;
    @ConfigField(desc="SMTP host", alias="mailer-smtp-host")
    private String smtpHost;
    @ConfigField(desc="SMTP password", alias="mailer-smtp-password", type=ConfigFieldType.Password)
    private String smtpPassword;
    @ConfigField(desc="SMTP port", alias="mailer-smtp-port")
    private String smtpPort = "587";
    @ConfigField(desc="SMTP username", alias="mailer-smtp-username")
    private String smtpUsername;

    public void setFromAddress(String fromAddress) {
        try {
            InternetAddress internetAddress = new InternetAddress(fromAddress);
            internetAddress.validate();
        }
        catch (AddressException e) {
            this.log.log(Level.SEVERE, "Address: " + fromAddress + " is invalid: " + e);
        }
        this.fromAddress = fromAddress;
    }

    public void initialize() {
        this.log.config("Configuring Mailer...");
        Properties sessionProperties = new Properties();
        sessionProperties.put("mail.smtp.auth", "false");
        sessionProperties.put("mail.smtp.starttls.enable", "true");
        sessionProperties.put("mail.smtp.ssl.trust", "*");
        sessionProperties.put("mail.smtps.ssl.trust", "*");
        sessionProperties.put("mail.smtp.timeout", (Object)5000);
        sessionProperties.put("mail.smtp.ssl.checkserveridentity", "false");
        sessionProperties.put("mail.smtp.ssl.trust", "*");
        sessionProperties.put("mail.smtp.starttls.checkserveridentity", "false");
        sessionProperties.put("mail.smtp.starttls.trust", "*");
        try {
            sessionProperties.put("mail.smtp.host", this.smtpHost);
            sessionProperties.put("mail.smtp.port", this.smtpPort);
            this.log.log(Level.CONFIG, "Setting username: {0}", this.smtpUsername);
            if (this.smtpPassword != null && !this.smtpPassword.isEmpty()) {
                this.log.log(Level.CONFIG, "Setting password: {0}", this.smtpPassword.replaceAll(".", "*"));
            }
            this.log.log(Level.CONFIG, "Setting default fromAddress: {0}", this.fromAddress);
            this.session = Session.getInstance((Properties)sessionProperties);
            this.log.log(Level.CONFIG, "Setting session: {0}", this.session);
        }
        catch (RuntimeException e) {
            this.log.log(Level.WARNING, "Mailer is not started", e);
            return;
        }
        this.log.config("Mailer is configured");
    }

    public void sendMail(String toAddresses, String messageSubject, String messageText) throws MailerException {
        this.sendMail(null, toAddresses, messageSubject, messageText);
    }

    public void sendMail(String from, String toAddresses, String messageSubject, String messageText) {
        this.sendMail(from, toAddresses, messageSubject, messageText, TYPE.PLAIN);
    }

    public void sendMail(String from, String toAddresses, String messageSubject, String messageText, TYPE type) throws MailerException {
        try {
            InternetAddress[] to;
            MimeMessage message;
            if (this.log.isLoggable(Level.FINE)) {
                message = messageText != null ? StringUtilities.convertNonPrintableCharactersToLiterals((String)(messageText.substring(0, Math.min(messageText.length(), 2048)) + " ...")) : null;
                this.log.log(Level.FINE, "Sending mail, to: {0}, subject: {1}, message: {2}", new Object[]{toAddresses, messageSubject, message});
            }
            message = new MimeMessage(this.session);
            if (from == null) {
                message.setFrom((Address)new InternetAddress(this.fromAddress));
            } else {
                message.setFrom((Address)new InternetAddress(from));
            }
            for (InternetAddress address : to = InternetAddress.parse((String)toAddresses)) {
                address.validate();
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
            message.setSubject(messageSubject);
            switch (type) {
                case HTML: {
                    message.setContent((Object)messageText, type.getType());
                    break;
                }
                case PLAIN: {
                    message.setText(messageText);
                }
            }
            if (this.smtpUsername == null || this.smtpUsername.trim().isEmpty()) {
                Transport.send((Message)message, (Address[])to);
            } else {
                Transport.send((Message)message, (Address[])to, (String)this.smtpUsername, (String)this.smtpPassword);
            }
        }
        catch (SMTPAddressFailedException | AddressException e) {
            this.handleException(Level.FINE, toAddresses, messageSubject, messageText, (Exception)e);
        }
        catch (SendFailedException e) {
            this.handleException(Level.INFO, toAddresses, messageSubject, messageText, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(Level.WARNING, toAddresses, messageSubject, messageText, e);
        }
    }

    private void handleException(Level logLevel, String toAddresses, String messageSubject, String messageText, Exception e) {
        this.log.log(logLevel, "Can''t send mail to: " + toAddresses + ", subject: " + messageSubject + ", text size: " + (messageText != null ? Integer.valueOf(messageText.length()) : null) + ", exception: " + e);
        throw new MailerException(e);
    }

    public static enum TYPE {
        PLAIN("text/plain"),
        HTML("text/html");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

