/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.monitor;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventListener;
import tigase.extras.mailer.Mailer;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.MonitorComponent;
import tigase.monitor.MonitorExtension;
import tigase.xml.Element;

@Bean(name="monitor-mailer", active=true, exportable=true)
public class MonitorMailer
implements MonitorExtension,
Initializable,
UnregisterAware {
    private static final String REMOTE_EVENT_INDICATOR = "remote";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Email notification sender", alias="from-address")
    private String fromAddress = null;
    @Inject
    private Mailer mailSender;
    @ConfigField(desc="Email notification recipients", alias="to-addresses")
    private String toAddresses;
    private final EventListener<Element> handler = new EventListener<Element>(){

        public void onEvent(Element event) {
            String eventFullName = event.getName();
            int i = eventFullName.lastIndexOf(".");
            String packageName = i >= 0 ? eventFullName.substring(0, i) : "";
            String eventName = eventFullName.substring(i + 1);
            MonitorMailer.this.onEvent(eventName, packageName, event);
        }
    };

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void beforeUnregister() {
        this.eventBus.removeListener(this.handler);
    }

    public void initialize() {
        this.log.config("Initializing Monitor Mailer");
        this.eventBus.addListener("tigase.monitor.tasks", null, this.handler);
    }

    public void setProperties(Map<String, Object> props) {
        this.log.config("Configuring Monitor Mailer");
        try {
            this.fromAddress = this.getRequiredProp(props, "mailer-from-address");
            this.log.log(Level.CONFIG, "Setting fromAddress: {0}", this.fromAddress);
            this.toAddresses = this.getRequiredProp(props, "mailer-to-addresses");
            this.log.log(Level.CONFIG, "Setting toAddresses: {0}", this.toAddresses);
        }
        catch (RuntimeException e) {
            this.log.warning(e.getMessage());
            this.log.warning("Mailer is not started");
            return;
        }
    }

    protected void onEvent(String name, String xmlns, Element event) {
        if (event.getAttributeStaticStr(REMOTE_EVENT_INDICATOR) != null) {
            return;
        }
        String subject = "Tigase Monitor Notification";
        StringBuilder sb = new StringBuilder();
        sb.append("Tigase Monitor generated event!\n\n");
        sb.append("hostname: ").append(this.component.getDefHostName()).append('\n');
        if ("SampleTaskEnabled".equals(name)) {
            String t = event.getCData(new String[]{"tigase.monitor.tasks.SampleTaskEnabled", "message"});
            subject = subject + " - " + t;
            sb.append("This is notification from sample monitor task.").append('\n');
            for (Element c : event.getChildren()) {
                sb.append("    ").append(c.getName()).append(": ").append(c.getCData()).append('\n');
            }
        } else {
            sb.append("Event: ").append(name).append('\n');
            for (Element c : event.getChildren()) {
                sb.append("    ").append(c.getName()).append(": ").append(c.getCData()).append('\n');
            }
        }
        this.sendMail(subject, sb.toString());
    }

    private String getRequiredProp(Map<String, Object> props, String name) {
        String result;
        try {
            result = (String)props.get(name);
        }
        catch (Exception e) {
            result = null;
            this.log.warning("Problem on reading property '" + name + "'");
        }
        if (result == null) {
            throw new RuntimeException("Property '" + name + "' is not defined!");
        }
        return result;
    }

    private void sendMail(String messageSubject, String messageText) {
        this.mailSender.sendMail(this.fromAddress, this.toAddresses, messageSubject, messageText);
    }
}

