/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.emailconfirm;

import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import tigase.extras.emailconfirm.EmailConfirmationSender;
import tigase.xmpp.XMPPProcessorException;

public class EmailConfirmationSenderTest {
    private EmailConfirmationSender emailConfirmationSender;

    @Before
    public void setUp() {
        this.emailConfirmationSender = new EmailConfirmationSender();
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersWithoutAt() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "mark"));
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersEmpty() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", ""));
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersDomain() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "example.com"));
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersWithSpace1() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "ffasdf    ssdfsdf@com"));
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersWithSpace2() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "ffasdf    ssdfsdf@com     "));
    }

    @Test(expected=XMPPProcessorException.class)
    public void checkRequiredParametersWithSpace3() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "    ffasdf    ssdfsdf@com"));
    }

    @Test
    public void checkRequiredParametersCorrectAddress() throws XMPPProcessorException {
        this.emailConfirmationSender.checkRequiredParameters(null, Map.of("email", "mail@domain.com"));
    }
}

