/*
 * Tigase Server Extras Base - Extra modules to Tigase Server
 * Copyright (C) 2007 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.management;

//
// Generated by mibgen version 5.1 (03/08/07) when compiling TIGASE-MANAGEMENT-MIB.
//

// java imports
//

import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;

import javax.management.MBeanServer;
import java.io.Serializable;

import static tigase.management.StatisticsConstatnts.*;

// jmx imports
//
// jdmk imports
//

/**
 * The class is used for implementing the "TigaseUser" group. The group is defined with the following oid:
 * 1.3.6.1.4.1.16120609.2.145.3.163.1.1.1.
 */
public class TigaseUser
		implements TigaseUserMBean, Serializable {

	/**
	 * Variable for storing the value of "TigaseUserRegisteredCount". The variable is identified by:
	 * "1.3.6.1.4.1.16120609.2.145.3.163.1.1.1.2".
	 */
	protected Long TigaseUserRegisteredCount = new Long(1);

	/**
	 * Variable for storing the value of "TigaseUserSessionCount". The variable is identified by:
	 * "1.3.6.1.4.1.16120609.2.145.3.163.1.1.1.1".
	 */
	protected Long TigaseUserSessionCount = new Long(1);

	/**
	 * Constructor for the "TigaseUser" group. If the group contains a table, the entries created through an SNMP SET
	 * will not be registered in Java DMK.
	 */
	public TigaseUser(SnmpMib myMib) {
	}

	/**
	 * Constructor for the "TigaseUser" group. If the group contains a table, the entries created through an SNMP SET
	 * will be AUTOMATICALLY REGISTERED in Java DMK.
	 */
	public TigaseUser(SnmpMib myMib, MBeanServer server) {
	}

	public Long getTigaseUserRegisteredCount() throws SnmpStatusException {
		TigaseUserRegisteredCount = StatisticsUtils.getStatsValue(SM_COMP, REGISTERED_USERS_STAT,
																  TigaseUserRegisteredCount);
		return TigaseUserRegisteredCount;
	}

	public Long getTigaseUserSessionCount() throws SnmpStatusException {
		TigaseUserSessionCount = StatisticsUtils.getStatsValue(SM_COMP, OPEN_SESSIONS_STAT, TigaseUserSessionCount);
		return TigaseUserSessionCount;
	}

}
