/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras;

import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.extras.mailer.Mailer;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;

public class AbstractEmailSender {
    private static final Logger log = Logger.getLogger(AbstractEmailSender.class.getCanonicalName());
    @Inject
    private Mailer mailer;
    private SimpleTemplateEngine ste = new SimpleTemplateEngine();
    @ConfigField(desc="Notification email subject")
    private String subject;
    @ConfigField(desc="Email template file")
    private String templateFile;

    public AbstractEmailSender(String subject, String templateFile) {
        this.subject = subject;
        this.templateFile = templateFile;
    }

    public void sendMail(String email, Map<String, Object> bindings) throws Exception {
        Writable w = null;
        try {
            Template template = this.ste.createTemplate(this.load(this.templateFile));
            w = template.make(bindings);
            this.mailer.sendMail(email, this.subject, w.toString());
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Failed to send email to " + email + ", message: " + w, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String load(String file) throws IOException {
        File f = new File(file);
        InputStream is = null;
        is = f.exists() ? new FileInputStream(new File(file)) : this.getClass().getResourceAsStream("/" + file);
        if (is == null) {
            throw new IOException("Resource not found");
        }
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader(is);){
            int read;
            while ((read = r.read(buf)) > -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }
}

