/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.http.upload;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.extras.http.upload.S3Store;
import tigase.xmpp.jid.BareJID;

@Ignore
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class S3StoreTest {
    private static S3Store store;
    private static BareJID uploaderJid;
    private static String slotId;
    private static String filename;
    private static byte[] data;

    @BeforeClass
    public static void setup() throws NoSuchFieldException, IllegalAccessException, NoSuchAlgorithmException {
        uploaderJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"test.com");
        slotId = UUID.randomUUID().toString();
        filename = S3StoreTest.generateFilename("test-");
        data = S3StoreTest.generateData();
        Logger.getGlobal().setLevel(Level.ALL);
        store = new S3Store();
        S3StoreTest.store.bucket = "test-bucket-wojtek1";
        S3StoreTest.store.autocreateBucket = true;
        store.beanConfigurationChanged(Collections.emptyList());
    }

    @AfterClass
    public static void cleanup() throws NoSuchFieldException, IllegalAccessException, NoSuchAlgorithmException {
        S3StoreTest.store.s3.listObjectsV2(S3StoreTest.store.bucket).getObjectSummaries().stream().map(S3ObjectSummary::getKey).forEach(key -> S3StoreTest.store.s3.deleteObject(S3StoreTest.store.bucket, key));
        S3StoreTest.store.s3.deleteBucket(S3StoreTest.store.bucket);
    }

    @Test
    public void test1_upload() throws IOException {
        store.setContent(uploaderJid, slotId, filename, (long)data.length, Channels.newChannel(new ByteArrayInputStream(data)));
    }

    @Test
    public void test2_download() throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        WritableByteChannel tmp = Channels.newChannel(boas);
        ReadableByteChannel in = store.getContent(uploaderJid, slotId, filename);
        int read = 0;
        while (in.isOpen() && read >= 0) {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            read = in.read(buffer);
            buffer.flip();
            tmp.write(buffer);
        }
        Assert.assertEquals((long)data.length, (long)boas.size());
        Assert.assertArrayEquals((byte[])data, (byte[])boas.toByteArray());
    }

    @Test
    public void test3_countFiles() throws IOException {
        Assert.assertEquals((long)1L, (long)store.count());
    }

    @Test
    public void test4_countSize() throws IOException {
        Assert.assertEquals((long)data.length, (long)store.size());
    }

    @Test
    public void test5_delete() throws IOException {
        store.remove(uploaderJid, slotId);
        Assert.assertEquals((long)0L, (long)store.count());
    }

    static byte[] generateData() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstanceStrong();
        byte[] data = new byte[random.nextInt(102400) + random.nextInt(1024)];
        random.nextBytes(data);
        return data;
    }

    static String generateFilename(String prefix) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder(prefix);
        SecureRandom random = SecureRandom.getInstanceStrong();
        int limit = 8 + random.nextInt(8);
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(limit).collect(() -> sb, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

