/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter.converters;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.db.comp.RepositoryItem;
import tigase.db.converter.Converter;
import tigase.db.converter.Convertible;
import tigase.db.converter.QueryExecutor;
import tigase.db.converter.converters.UserDataQueries;
import tigase.db.converter.converters.UserEntity;
import tigase.db.converter.converters.UserRosterItem;
import tigase.kernel.beans.Inject;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xmpp.jid.BareJID;

public class UserCredentialsConverter
implements Convertible<UserEntity> {
    @Inject
    AuthRepository authRepository;
    Converter.ConverterProperties properties;
    @Inject
    QueryExecutor queryExecutor;
    @Inject
    UserRepository userRepository;
    @Inject
    VHostManager vHostManager;
    private UserDataQueries queries;

    @Override
    public void initialise(Converter.ConverterProperties properties) {
        this.properties = properties;
        this.queries = new UserDataQueries(properties.getServerType(), properties.getDatabaseType());
    }

    @Override
    public Optional<String> getMainQuery() {
        return this.queries.getQuery(QUERY.users.name());
    }

    @Override
    public Optional<UserEntity> processResultSet(ResultSet rs) throws Exception {
        String username = null;
        String server_host = null;
        String password = null;
        switch (this.properties.getServerType()) {
            case ejabberd: {
                username = rs.getString("username");
                server_host = this.properties.getVHost();
                password = rs.getString("password");
                break;
            }
            case ejabberd_new: {
                username = rs.getString("username");
                server_host = rs.getString("server_host");
                password = rs.getString("password");
            }
        }
        if (username != null && server_host != null && password != null) {
            BareJID jid = BareJID.bareJIDInstance((String)username, (String)server_host);
            UserEntity userEntity = new UserEntity(jid, password);
            this.addRosterItems(userEntity, jid);
            return Optional.of(userEntity);
        }
        return Optional.empty();
    }

    @Override
    public boolean storeEntity(UserEntity entity) throws Exception {
        String roster;
        this.authRepository.addUser(entity.getJid(), entity.getPassword());
        if (!this.vHostManager.isLocalDomain(entity.getJid().getDomain())) {
            VHostItem vHostItem = new VHostItem(entity.getJid().getDomain());
            this.vHostManager.getComponentRepository().addItem((RepositoryItem)vHostItem);
        }
        if ((roster = entity.getRosterItems().stream().map(userRosterItem -> userRosterItem.getRosterElement().getRosterElement().toString()).collect(Collectors.joining())) != null && !roster.isEmpty()) {
            this.userRepository.setData(entity.getJid(), null, "roster", roster);
        }
        return true;
    }

    @Override
    public Map<String, String> getAdditionalQueriesToInitialise() {
        return this.queries.getAllQueriesForServerAndDatabase().orElse(Collections.emptyMap());
    }

    private void addRosterItems(UserEntity userEntity, BareJID jid) throws Exception {
        List<UserRosterItem> rosterItems = this.queryExecutor.executeQuery(QUERY.rosteritems.name(), this.getRosterItems(jid));
        userEntity.addRosterItems(rosterItems);
    }

    private QueryExecutor.QueryFunction<PreparedStatement, List<String>> getRosterItemGroups(BareJID ownerJid, BareJID contactJid) {
        return preparedStatement -> {
            CopyOnWriteArrayList<String> items = new CopyOnWriteArrayList<String>();
            ResultSet resultSet = null;
            preparedStatement.setString(1, String.valueOf(ownerJid.getLocalpart()));
            preparedStatement.setString(2, String.valueOf(contactJid));
            if (Converter.SERVER.ejabberd_new.equals((Object)this.properties.getServerType())) {
                preparedStatement.setString(3, String.valueOf(ownerJid.getDomain()));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String group = resultSet.getString("grp");
                items.add(group);
            }
            return items;
        };
    }

    private QueryExecutor.QueryFunction<PreparedStatement, List<UserRosterItem>> getRosterItems(BareJID jid) {
        return preparedStatement -> {
            CopyOnWriteArrayList<UserRosterItem> items = new CopyOnWriteArrayList<UserRosterItem>();
            ResultSet resultSet = null;
            preparedStatement.setString(1, String.valueOf(jid.getLocalpart()));
            if (Converter.SERVER.ejabberd_new.equals((Object)this.properties.getServerType())) {
                preparedStatement.setString(2, String.valueOf(jid.getDomain()));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String conJidStr = resultSet.getString("jid");
                BareJID conJid = BareJID.bareJIDInstance((String)conJidStr);
                String nick = resultSet.getString("nick");
                String subscription = resultSet.getString("subscription");
                List<String> groups = this.queryExecutor.executeQuery(QUERY.rostergroups.name(), this.getRosterItemGroups(jid, conJid));
                UserRosterItem userRosterItem = new UserRosterItem(jid, conJid, nick, subscription, groups);
                items.add(userRosterItem);
            }
            return items;
        };
    }

    static enum QUERY {
        users,
        rosteritems,
        rostergroups,
        vcard;

    }
}

