/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter.converters;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import tigase.db.converter.RowEntity;
import tigase.db.converter.converters.UserRosterItem;
import tigase.xmpp.jid.BareJID;

public class UserEntity
implements RowEntity {
    BareJID jid;
    String password;
    List<UserRosterItem> rosterItems = new CopyOnWriteArrayList<UserRosterItem>();

    public UserEntity(BareJID jid, String password) {
        this.jid = jid;
        this.password = password;
    }

    public BareJID getJid() {
        return this.jid;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getID() {
        return String.valueOf(this.jid);
    }

    public boolean addRosterItem(UserRosterItem item) {
        return this.rosterItems.add(item);
    }

    public List<UserRosterItem> getRosterItems() {
        return Collections.unmodifiableList(this.rosterItems);
    }

    public boolean addRosterItems(List<UserRosterItem> items) {
        return this.rosterItems.addAll(items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserEntity{");
        sb.append("jid=").append(this.jid);
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", rosterItems=").append(this.rosterItems);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        if (this.jid != null ? !this.jid.equals((Object)that.jid) : that.jid != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.rosterItems != null ? this.rosterItems.equals(that.rosterItems) : that.rosterItems == null;
    }

    public int hashCode() {
        int result = this.jid != null ? this.jid.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.rosterItems != null ? this.rosterItems.hashCode() : 0);
        return result;
    }
}

