/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter.converters;

import java.util.List;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

class UserRosterItem {
    final List<String> groups;
    final BareJID jid;
    final String nick;
    final BareJID ownerJid;
    final RosterElement rosterElement;
    final RosterAbstract.SubscriptionType subscription;

    public UserRosterItem(BareJID ownerJid, BareJID iid, String nick, String subscription, List<String> groups) {
        this.ownerJid = ownerJid;
        this.jid = iid;
        this.nick = nick;
        switch (subscription) {
            case "B": {
                this.subscription = RosterAbstract.SubscriptionType.both;
                break;
            }
            case "T": {
                this.subscription = RosterAbstract.SubscriptionType.to;
                break;
            }
            case "F": {
                this.subscription = RosterAbstract.SubscriptionType.from;
                break;
            }
            default: {
                this.subscription = RosterAbstract.SubscriptionType.none;
            }
        }
        this.groups = groups;
        this.rosterElement = new RosterElement(JID.jidInstance((BareJID)this.jid), nick, groups.toArray(new String[0]));
        this.rosterElement.setSubscription(this.subscription);
    }

    public RosterElement getRosterElement() {
        return this.rosterElement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserRosterItem{");
        sb.append("ownerJid=").append(this.ownerJid);
        sb.append(", jid=").append(this.jid);
        sb.append(", nick='").append(this.nick).append('\'');
        sb.append(", subscription=").append(this.subscription);
        sb.append(", groups=").append(this.groups);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRosterItem that = (UserRosterItem)o;
        if (this.ownerJid != null ? !this.ownerJid.equals((Object)that.ownerJid) : that.ownerJid != null) {
            return false;
        }
        if (this.jid != null ? !this.jid.equals((Object)that.jid) : that.jid != null) {
            return false;
        }
        if (this.nick != null ? !this.nick.equals(that.nick) : that.nick != null) {
            return false;
        }
        if (this.subscription != null ? !this.subscription.equals((Object)that.subscription) : that.subscription != null) {
            return false;
        }
        return this.groups != null ? this.groups.equals(that.groups) : that.groups == null;
    }

    public int hashCode() {
        int result = this.ownerJid != null ? this.ownerJid.hashCode() : 0;
        result = 31 * result + (this.jid != null ? this.jid.hashCode() : 0);
        result = 31 * result + (this.nick != null ? this.nick.hashCode() : 0);
        result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        return result;
    }
}

