/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auditlog.AuditLogComponent;
import tigase.auditlog.Entry;
import tigase.auditlog.LogSearchableRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.SDRepositoryBean;
import tigase.kernel.beans.Bean;
import tigase.util.dns.DNSResolverFactory;
import tigase.xmpp.jid.BareJID;

@Bean(name="searchableRepository", parent=AuditLogComponent.class, active=false)
public class LogSearchableSDRepositoryBean
extends SDRepositoryBean<LogSearchableRepository>
implements LogSearchableRepository {
    private static final Logger a = Logger.getLogger(LogSearchableSDRepositoryBean.class.getCanonicalName());

    public void initialize() {
        super.initialize();
        String string = DNSResolverFactory.getInstance().getDefaultHost();
        try {
            this.markUsersAsDisconnected(string, new Date());
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, "could not update users from node " + string + " as disconnected", repositoryException);
        }
    }

    public void beforeUnregister() {
        String string = DNSResolverFactory.getInstance().getDefaultHost();
        try {
            this.markUsersAsDisconnected(string, new Date());
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, "could not update users from node " + string + " as disconnected", throwable);
        }
        super.beforeUnregister();
    }

    @Override
    public List<LogSearchableRepository.ConnectionHistory> getActiveConnections(BareJID userJID) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getActiveConnections(userJID);
    }

    @Override
    public List<LogSearchableRepository.ConnectionHistory> getLastConnections(BareJID userJID) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getLastConnections(userJID);
    }

    @Override
    public LogSearchableRepository.ConnectionStatistics getConnectionStatistics(BareJID userJID, Date from, Date to) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getConnectionStatistics(userJID, from, to);
    }

    @Override
    public List<LogSearchableRepository.ConnectionHistory> getConnectionHistory(BareJID userJID, Date from, Date to) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getConnectionHistory(userJID, from, to);
    }

    public List<BareJID> getConnectedUsers(String domain, String userLike) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getConnectedUsers(domain, userLike);
    }

    public List<BareJID> getDisconnectedUsers(String domain, String userLike) throws RepositoryException {
        return ((LogSearchableRepository)this.getRepository()).getDisconnectedUsers(domain, userLike);
    }

    @Override
    public void markUsersAsDisconnected(String clusterNode, Date timestamp) throws RepositoryException {
        ((LogSearchableRepository)this.getRepository()).markUsersAsDisconnected(clusterNode, timestamp);
    }

    @Override
    public void append(Entry entry) throws RepositoryException {
        ((LogSearchableRepository)this.getRepository()).append(entry);
    }

    @Override
    public List<Entry> getCachedEntries(int offset, int limit) {
        return null;
    }

    public void setDataSource(DataSource dataSource) throws RepositoryException {
    }

    protected Class<?> findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(LogSearchableRepository.class, (String)dataSource.getResourceUri());
    }
}

