/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.auditlog.Entry;
import tigase.auditlog.LogSearchableRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JDBCRepositoryTest<DS extends DataSource, R extends LogSearchableRepository>
extends AbstractDataSourceAwareTestCase<DS, R> {
    private final SecureRandom random = new SecureRandom();
    private static final String PROJECT_ID = "auditlog";
    private static final String VERSION = "2.0.0";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };

    @BeforeClass
    public static void loadSchema() throws DBInitException {
        JDBCRepositoryTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton("audit-log"));
    }

    @Test
    public void testActiveConnections() throws TigaseStringprepException, RepositoryException {
        JID user1 = JID.jidInstance((String)UUID.randomUUID().toString(), (String)(UUID.randomUUID().toString() + ".test.com"), (String)"res-1");
        String clientIP = this.randomIP();
        Entry e = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("success").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e);
        List results = ((LogSearchableRepository)this.repo).getActiveConnections(user1.getBareJID());
        Assert.assertEquals((long)1L, (long)results.size());
        LogSearchableRepository.ConnectionHistory result = (LogSearchableRepository.ConnectionHistory)results.get(0);
        Assert.assertEquals((Object)e.getSessionId(), (Object)result.getSessionId());
        Assert.assertEquals((Object)e.getWhen(), (Object)result.getTimestamp());
        Assert.assertEquals((Object)e.getClusterNode(), (Object)result.getClusterNode());
        Assert.assertEquals((Object)e.getClientIP(), (Object)result.getClientIP());
        Assert.assertTrue((result.getDuration() < 1000.0 && result.getDuration() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testLastConnections() throws TigaseStringprepException, RepositoryException {
        JID user1 = JID.jidInstance((String)UUID.randomUUID().toString(), (String)(UUID.randomUUID().toString() + ".test.com"), (String)"res-1");
        String clientIP = this.randomIP();
        Entry e = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("success").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e);
        Entry e1 = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("disconnected").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e1);
        List results = ((LogSearchableRepository)this.repo).getLastConnections(user1.getBareJID());
        Assert.assertEquals((long)1L, (long)results.size());
        LogSearchableRepository.ConnectionHistory result = (LogSearchableRepository.ConnectionHistory)results.get(0);
        Assert.assertEquals((Object)e.getSessionId(), (Object)result.getSessionId());
        Assert.assertEquals((Object)e1.getWhen(), (Object)result.getTimestamp());
        Assert.assertEquals((Object)e.getClusterNode(), (Object)result.getClusterNode());
        Assert.assertEquals((Object)e.getClientIP(), (Object)result.getClientIP());
        Assert.assertTrue((result.getDuration() < 1000.0 && result.getDuration() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testConnectedUsers() throws TigaseStringprepException, RepositoryException {
        JID user1 = JID.jidInstance((String)UUID.randomUUID().toString(), (String)(UUID.randomUUID().toString() + ".test.com"), (String)"res-1");
        String clientIP = this.randomIP();
        Entry e = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("success").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e);
        List results = ((LogSearchableRepository)this.repo).getConnectedUsers(user1.getDomain(), null);
        Assert.assertEquals((long)1L, (long)results.size());
        LogSearchableRepository.ConnectionEntry result = (LogSearchableRepository.ConnectionEntry)results.get(0);
        Assert.assertEquals((Object)user1, (Object)result.getUserJID());
        Assert.assertEquals((Object)e.getWhen(), (Object)result.getFrom());
        Assert.assertTrue((result.getDuration() < 1000.0 && result.getDuration() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDisconnectedUsers() throws TigaseStringprepException, RepositoryException {
        JID user1 = JID.jidInstance((String)UUID.randomUUID().toString(), (String)(UUID.randomUUID().toString() + ".test.com"), (String)"res-1");
        String clientIP = this.randomIP();
        Entry e = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("success").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e);
        Entry e1 = new Entry.Builder().withSessionId(UUID.randomUUID().toString()).withUserJID(user1).withConnectionId(JID.jidInstance((String)("c2s@node1.test.com/" + this.randomIP() + "_5222_" + clientIP + "_34694"))).ofType("auth").ofSubtype("disconnected").onClusterNode("node1.test.com").build();
        ((LogSearchableRepository)this.repo).append(e1);
        List results = ((LogSearchableRepository)this.repo).getDisconnectedUsers(user1.getDomain(), null);
        Assert.assertEquals((long)1L, (long)results.size());
        LogSearchableRepository.ConnectionEntry result = (LogSearchableRepository.ConnectionEntry)results.get(0);
        Assert.assertEquals((Object)user1, (Object)result.getUserJID());
        Assert.assertEquals((Object)e1.getWhen(), (Object)result.getFrom());
        Assert.assertTrue((result.getDuration() < 1000.0 && result.getDuration() > 0.0 ? 1 : 0) != 0);
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return LogSearchableRepository.class;
    }

    private String randomIP() {
        return "" + this.random(256) + "." + this.random(256) + "." + this.random(256) + "." + this.random(256);
    }

    private String random(int mask) {
        return "" + Math.abs(this.random.nextInt()) % mask;
    }
}

