/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
/*
 Retrieve code for manual licence retrieval
 AS:Description: Retrieve code for licence
 AS:CommandId: retrieve-code-for-licence
 AS:Component: vhost-man
 AS:Group: Licence
 */
package tigase.admin

import tigase.server.Command
import tigase.server.Iq
import tigase.xml.Element

def p = (Iq) packet

def admins = (Set) adminsSet
def stanzaFromBare = p.getStanzaFrom().getBareJID()
def isServiceAdmin = admins.contains(stanzaFromBare)

if (!isServiceAdmin) {
	def result = p.commandResult(Command.DataType.result);
	Command.addTextField(result, "Error", "You are not service administrator");
	return result
}

String componentId = Command.getFieldValue(p, "component-id");
if (componentId == null) {
	def possibleValues = (tigase.licence.LicenceChecker.getLicencedComponents() as List).sort();

	def result = p.commandResult(Command.DataType.form);

	Command.addTitle(result,
					 "Please select component ID for which you want to retrieve code required for manual licence retrieval")
	Command.addFieldValue(result, "component-id", "", "Component ID", possibleValues as String[],
						  possibleValues as String[], "list-single")
	return result
}

def result = p.commandResult(Command.DataType.result)

Command.addTitle(result, "Licence code");
Command.addInstructions(result, "Licence code contains following information:")
tigase.licence.LicenceChecker.getLicencingDetails(componentId).
		getChildren().
		each { Element child -> Command.addFieldValue(result, child.getName(), child.getCData(), "text-single");
		}

try {
	String code = tigase.licence.LicenceChecker.getCodeForLicenceRetrieval(componentId);
	Command.addFieldValue(result, "Code", code, "text-multi");
} catch (Exception e) {
	Command.addTextField(result, "Error", e.getMessage())
}

return result;