/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.StatisticsData;
import tigase.stats.collector.provider.HTTPException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class StatisticsUploader {
    private static final String a = "https://stats.tigase.software/upload";
    public static final String ERROR_QUERY = "?returnError=true";
    private static final Logger b = Logger.getLogger(StatisticsUploader.class.getCanonicalName());
    private static final Timer c = new Timer();
    private static final int d = 10;
    private static final int e = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final SimpleParser f = SingletonFactory.getParserInstance();
    private final String g;
    private final ElementSigner h;

    public StatisticsUploader(ElementSigner signer) {
        this.h = signer;
        this.g = a;
    }

    public StatisticsUploader(ElementSigner signer, String url, boolean returnError) {
        this.h = signer;
        this.g = (url != null ? url : a) + (returnError ? ERROR_QUERY : "");
    }

    public void upload(StatisticsData data, ResultCallback callback) {
        this.upload(data, callback, false);
    }

    public void upload(StatisticsData data, ResultCallback callback, boolean tester) {
        Element element = data.toElement();
        Element element2 = this.h.sign(element);
        String string = element2.toString();
        if (tester) {
            this.b(string, callback, 10);
        } else {
            this.a(string, callback, 0);
        }
    }

    private void a(final String string, final ResultCallback resultCallback, final int n) {
        b.log(Level.FINER, "Queuing data for upload, try {0} of {1}", new Object[]{n, 10});
        c.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsUploader.this.b(string, resultCallback, n);
            }
        }, TimeUnit.MINUTES.toMillis(n * 2));
    }

    private void b(String string, ResultCallback resultCallback, int n) {
        try {
            boolean bl = false;
            Element element = null;
            Exception exception = null;
            try {
                element = this.a(string);
                element = this.h.verify(element);
                bl = "result".equals(element.getAttribute("type"));
            }
            catch (Exception exception2) {
                b.log(Level.SEVERE, "Exception uploading statistics", exception2);
                exception = exception2;
            }
            if (!bl) {
                if (n >= 10) {
                    b.log(Level.WARNING, "could not upload statistics data, permanent upload failure");
                    resultCallback.onFailure(exception);
                } else {
                    b.log(Level.FINE, "could not upload statistics data, queuing for retry, attempt " + n + " out of 10");
                    this.a(string, resultCallback, n + 1);
                }
            } else {
                b.log(Level.FINER, "statistics data successfully uploaded");
                resultCallback.onSuccess(element);
            }
        }
        catch (Exception exception) {
            b.log(Level.SEVERE, "Exception during processing upload request, should not happen", exception);
        }
    }

    private Element a(String string) throws IOException {
        String string2;
        URL uRL = new URL(this.g);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(e);
        httpURLConnection.setReadTimeout(e * 5);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("Content-Type", "application/xml");
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string.length()));
        b.log(Level.FINE, "Sending data to url: {0}", new Object[]{uRL});
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string.getBytes());
        outputStream.flush();
        int n = httpURLConnection.getResponseCode();
        if (n / 100 != 2) {
            b.log(Level.FINE, "Server responded with the code: {0} and message: {1}", new Object[]{n, httpURLConnection.getResponseMessage()});
            throw new HTTPException(n);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringBuffer stringBuffer = new StringBuffer();
        DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            f.parse((SimpleHandler)domBuilderHandler, string2.toCharArray(), 0, string2.length());
        }
        b.log(Level.FINE, "Received: {0}", new Object[]{stringBuffer.toString()});
        Queue queue = domBuilderHandler.getParsedElements();
        if (queue.isEmpty()) {
            throw new IOException("No response");
        }
        return (Element)queue.poll();
    }

    public static interface ResultCallback {
        public void onSuccess(Element var1);

        public void onFailure(Exception var1);
    }
}

