/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import tigase.licence.utils.TooManyRequestsHTTPException;
import tigase.stats.collector.provider.HTTPException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class DataLoader {
    private static final Logger a = Logger.getLogger(DataLoader.class.getCanonicalName());
    private static final int b = (int)TimeUnit.SECONDS.toMillis(15L);
    private SimpleParser c = SingletonFactory.getParserInstance();
    private SSLSocketFactory d = null;

    public static <T> void addRequestItems(StringBuffer rawData, String fieldVar, List<T> items) {
        rawData.append("<item><var>").append(fieldVar).append("</var>");
        rawData.append("<value>");
        if (items != null && !items.isEmpty()) {
            for (T t : items) {
                rawData.append("<item>").append(t).append("</item>");
            }
        }
        rawData.append("</value>").append("</item>");
    }

    public static <K, V> void addRequestItems(StringBuffer rawData, Map<K, V> elements) {
        if (elements != null && !elements.isEmpty()) {
            for (Map.Entry<K, V> entry : elements.entrySet()) {
                rawData.append("<item><var>").append(entry.getKey()).append("</var>");
                rawData.append("<value>").append(entry.getValue()).append("</value>").append("</item>");
            }
        }
    }

    public Element loadData(String url, String encodedData) throws TooManyRequestsHTTPException, GeneralSecurityException, IOException, HTTPException {
        String string;
        Object object;
        InputStream inputStream;
        String string2 = "application/xml";
        URL uRL = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(b);
        httpURLConnection.setReadTimeout(b * 5);
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("Content-Type", string2);
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(encodedData.length()));
        OutputStream outputStream = httpURLConnection.getOutputStream();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Sending data: {0} to url: {1}, resolved host: {2}", new Object[]{encodedData, uRL, InetAddress.getByName(uRL.getHost())});
        }
        outputStream.write(encodedData.getBytes());
        outputStream.flush();
        int n = httpURLConnection.getResponseCode();
        InputStream inputStream2 = inputStream = n / 100 == 2 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        if (n == 429) {
            object = httpURLConnection.getHeaderField("Retry-After");
            if (null != object && !((String)object).isEmpty()) {
                int n2 = Integer.valueOf((String)object);
                throw new TooManyRequestsHTTPException(n, n2);
            }
        } else if (n / 100 != 2) {
            throw new HTTPException(n);
        }
        object = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            stringBuilder.append(string);
            this.c.parse((SimpleHandler)domBuilderHandler, string.toCharArray(), 0, string.length());
        }
        ((BufferedReader)object).close();
        Element element = (Element)domBuilderHandler.getParsedElements().poll();
        a.log(Level.FINEST, "Retrieved data from server, response: {0}, (parsed): {1}, sb: {2} ", new Object[]{n, element, stringBuilder});
        return element;
    }
}

