/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.cluster.commands;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.cluster.MixComponentClustered;
import tigase.mix.cluster.RoomPresenceRepositoryClustered;
import tigase.pubsub.cluster.ClusteredNodeStrategy;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="request-temp-participants-sync", parent=MixComponentClustered.class, active=true)
public class RequestTempParticipantsSyncCommand
extends CommandListenerAbstract {
    public static final String REQUEST_TEMP_PARTICIPANTS_SYNC_CMD = "request-temp-participants-sync";
    private static final int a = 500;
    @Inject(nullAllowed=true)
    private RoomPresenceRepositoryClustered roomPresenceRepository;
    @Inject
    private ClusteredNodeStrategy strategy;

    public RequestTempParticipantsSyncCommand() {
        super(REQUEST_TEMP_PARTICIPANTS_SYNC_CMD, Priority.HIGH);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        if (this.roomPresenceRepository != null) {
            LinkedList<Object> linkedList = new LinkedList<Element>();
            Element element = null;
            int n = 0;
            for (Map.Entry entry : this.roomPresenceRepository.getTempParticipantsPresence()) {
                BareJID bareJID = (BareJID)entry.getKey();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    if (element == null || !element.getAttributeStaticStr("jid").equals(bareJID.toString())) {
                        element = new Element("channel").withAttribute("jid", bareJID.toString());
                        linkedList.add(element);
                    }
                    element.addChild((XMLNodeIfc)new Element("item").withAttribute("nick", (String)entry2.getKey()).withAttribute("jid", ((JID)entry2.getValue()).toString()));
                    if (++n < 500) continue;
                    this.strategy.sendToNodes(REQUEST_TEMP_PARTICIPANTS_SYNC_CMD, linkedList, fromNode);
                    linkedList = new LinkedList();
                    element = null;
                    n = 0;
                }
            }
            if (!linkedList.isEmpty()) {
                this.strategy.sendToNodes(REQUEST_TEMP_PARTICIPANTS_SYNC_CMD, linkedList, fromNode);
            }
        }
    }
}

