/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.cluster.commands;

import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.cluster.MixRepositoryClustered;
import tigase.mix.cluster.RoomPresenceRepositoryClustered;
import tigase.mix.cluster.StrategyIfc;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="nodesChangedCmd", parent=StrategyIfc.class, active=true)
public class NodesChangedCommand
extends tigase.pubsub.cluster.commands.NodesChangedCommand {
    public static final String CHANNEL_CONFIG_CHANGED = "channel-config-changed";
    public static final String CHANNEL_PARTICIPANT_INVALIDATED = "channel-participant-invalidated";
    public static final String TEMP_PARTICIPANT_JOINED = "channel-temp-participant-joined";
    public static final String TEMP_PARTICIPANT_LEFT = "channel-temp-participant-left";
    @Inject
    private MixRepositoryClustered mixRepository;
    @Inject(nullAllowed=true)
    private RoomPresenceRepositoryClustered roomPresenceRepository;

    protected void executeAction(BareJID serviceJid, String nodeName, String action, Element elem) throws RepositoryException {
        switch (action) {
            case "channel-config-changed": {
                this.mixRepository.updateChannelConfiguration(serviceJid, elem.getChild("item"));
                break;
            }
            case "channel-participant-invalidated": {
                this.mixRepository.invalidateChannelParticipant(serviceJid, elem.getAttributeStaticStr("participant-id"));
                break;
            }
            case "channel-temp-participant-joined": {
                if (this.roomPresenceRepository == null) break;
                JID jID = JID.jidInstanceNS((String)elem.getAttributeStaticStr("jid"));
                String string = elem.getAttributeStaticStr("nick");
                this.roomPresenceRepository.addTempParticipantNoEvent(serviceJid, jID, string);
                break;
            }
            case "channel-temp-participant-left": {
                if (this.roomPresenceRepository == null) break;
                JID jID = JID.jidInstanceNS((String)elem.getAttributeStaticStr("jid"));
                String string = elem.getAttributeStaticStr("nick");
                this.roomPresenceRepository.removeTempParticipantNoEvent(serviceJid, jID, string);
                break;
            }
            default: {
                super.executeAction(serviceJid, nodeName, action, elem);
            }
        }
    }
}

