/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.cluster;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.mix.cluster.MixComponentClustered;
import tigase.mix.cluster.StrategyIfc;
import tigase.pubsub.cluster.ClusteredNodeStrategy;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="strategy", parent=MixComponentClustered.class, active=true)
public class ClusteredChannelsStrategy
extends ClusteredNodeStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(ClusteredChannelsStrategy.class.getCanonicalName());

    @Override
    public List<JID> getNodesForPacket(Packet packet) throws PubSubException {
        if (packet.getElemName() == "iq" && packet.getType() == StanzaType.result && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && packet.getElemChild("ping", "urn:xmpp:ping") != null) {
            JID jID = packet.getStanzaFrom();
            return Collections.singletonList(this.getClusterNodeForGhostbusterPing(jID));
        }
        return super.getNodesForPacket(packet);
    }

    @Override
    public void channelConfigurationChanged(BareJID channelJID, Element item) {
        Element element = new Element("channel-config-changed");
        element.setAttribute("service-jid", channelJID.toString());
        element.addChild((XMLNodeIfc)item);
        ((ArrayDeque)this.nodesModifications.get()).offer(element);
    }

    @Override
    public void invalidateChannelParticipant(BareJID channelJID, String participantID) {
        Element element = new Element("channel-participant-invalidated");
        element.setAttribute("service-jid", channelJID.toString());
        element.setAttribute("participant-id", participantID);
        ((ArrayDeque)this.nodesModifications.get()).offer(element);
    }

    @Override
    public void tempParticipantAdded(BareJID channelJID, JID jid, String nickname) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("channel-temp-participant-joined").withAttribute("service-jid", channelJID.toString()).withAttribute("jid", jid.toString()).withAttribute("nick", nickname));
    }

    @Override
    public void tempParticipantRemoved(BareJID channelJID, JID jid, String nickname) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("channel-temp-participant-left").withAttribute("service-jid", channelJID.toString()).withAttribute("jid", jid.toString()).withAttribute("nick", nickname));
    }

    public boolean shouldBroadcastMucMessage(JID recipient) {
        if (this.pubSubComponent.isLocalDomain(recipient.getDomain())) {
            TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
            boolean bl = tigaseRuntime.isJidOnlineLocally(recipient);
            a.log(Level.FINEST, () -> "should broadcast MUC message to local " + recipient + ": " + bl);
            return bl;
        }
        boolean bl = this.handleLocally(recipient.getBareJID());
        a.log(Level.FINEST, () -> "should broadcast MUC message to remote " + recipient + ": " + bl);
        return bl;
    }

    public boolean shouldSendPing(JID recipient) {
        return this.getLocalNodeJid().equals((Object)this.getClusterNodeForGhostbusterPing(recipient));
    }

    @Override
    protected void requestSync(JID nodeJid) {
        super.requestSync(nodeJid);
        this.cl_controller.sendToNodes("request-temp-participants-sync", this.localNodeJid, new JID[]{nodeJid});
    }

    protected JID getClusterNodeForGhostbusterPing(JID sender) {
        TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
        if (this.pubSubComponent.isLocalDomain(sender.getDomain()) && tigaseRuntime.isJidOnline(sender) && tigaseRuntime.isJidOnlineLocally(sender)) {
            return this.getLocalNodeJid();
        }
        if (this.handleLocally(sender.getBareJID())) {
            return this.getLocalNodeJid();
        }
        return this.getNodeForHashCode(sender.hashCode());
    }
}

