/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.xml.Element;

public class SSRCGroup {
    private final String semantics;
    private final List<String> sources;

    public static SSRCGroup from(Element el) {
        if ("ssrc-group".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(el.getXMLNS())) {
            String semantics = el.getAttributeStaticStr("semantics");
            if (semantics == null) {
                return null;
            }
            List<String> sources = Optional.ofNullable(el.mapChildren(it -> "source".equals(it.getName()), it -> it.getAttributeStaticStr("ssrc"))).orElse(Collections.emptyList());
            return new SSRCGroup(semantics, sources);
        }
        return null;
    }

    public static List<SSRCGroup> from(String[] lines) {
        return Arrays.stream(lines).filter(it -> it.startsWith("a=ssrc-group:")).map(it -> it.substring("a=ssrc-group:".length())).map(it -> it.split(" ")).filter(it -> ((String[])it).length >= 2).map(it -> new SSRCGroup(it[0], Arrays.stream(it).skip(1L).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public SSRCGroup(String semantics, List<String> sources) {
        this.semantics = semantics;
        this.sources = sources;
    }

    public String getSemantics() {
        return this.semantics;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public Element toElement() {
        Element el = new Element("ssrc-group");
        el.setXMLNS("urn:xmpp:jingle:apps:rtp:ssma:0");
        el.setAttribute("semantics", this.semantics);
        this.sources.stream().map(source -> new Element("source", new String[]{"ssrc"}, new String[]{source})).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        return el;
    }

    public String toSDP() {
        return Stream.concat(Stream.of("a=ssrc-group:" + this.semantics), this.sources.stream()).collect(Collectors.joining(" "));
    }
}

