/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.meet.jingle.Action;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.ContentAction;
import tigase.meet.jingle.Description;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class SDP {
    private final String id;
    private final List<Content> contents;
    private final List<String> bundle;

    public static SDP from(Element jingleEl) {
        List<Content> contents = Optional.ofNullable(jingleEl.getChildren()).orElse(Collections.emptyList()).stream().map(Content::from).filter(Objects::nonNull).collect(Collectors.toList());
        List groupChildren = Optional.ofNullable(jingleEl.getChild("group", "urn:xmpp:jingle:apps:grouping:0")).map(it -> it.getChildren()).orElse(Collections.EMPTY_LIST);
        List<String> bundle = groupChildren.stream().filter(it -> "content".equals(it.getName())).map(it -> it.getAttributeStaticStr("name")).filter(Objects::nonNull).collect(Collectors.toList());
        return new SDP(String.valueOf(new Date().getTime()), contents, bundle);
    }

    public static SDP from(String sdp, Function<String, Content.Creator> creatorProvider, Content.Creator localRole) {
        String[] parts = sdp.substring(0, sdp.length() - 2).split("\r\nm=");
        List media = Arrays.stream(parts).skip(1L).map(it -> "m=" + it).collect(Collectors.toList());
        String[] sessionLines = parts[0].split("\r\n");
        Optional<String[]> sessionLine = Arrays.stream(sessionLines).filter(it -> it.startsWith("o=")).findFirst().map(it -> it.split(" "));
        if (sessionLine.isEmpty() || sessionLine.get().length <= 3) {
            return null;
        }
        String sid = sessionLine.get()[1];
        String id = sessionLine.get()[2];
        Optional<String[]> groupParts = Arrays.stream(sessionLines).filter(it -> it.startsWith("a=group:BUNDLE ")).findFirst().map(it -> it.split(" "));
        List<String> bundle = groupParts.filter(it -> "a=group:BUNDLE".equals(it[0])).map(it -> Arrays.stream(it).skip(1L).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<Content> contents = media.stream().map(m -> Content.from(m, sessionLines, creatorProvider, localRole)).filter(Objects::nonNull).collect(Collectors.toList());
        return new SDP(id, contents, bundle);
    }

    public SDP(String id, List<Content> contents, List<String> bundle) {
        this.id = id;
        this.contents = contents;
        this.bundle = bundle;
    }

    public String getId() {
        return this.id;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public List<String> getBundle() {
        return this.bundle;
    }

    public Element toElement(Action action, String sessionId, JID from) {
        Element jingleEl = new Element("jingle");
        jingleEl.setAttribute("xmlns", "urn:xmpp:jingle:1");
        jingleEl.setAttribute("action", action.getValue());
        jingleEl.setAttribute("sid", sessionId);
        switch (action) {
            case sessionInitiate: {
                jingleEl.setAttribute("initiator", from.toString());
                break;
            }
            case sessionAccept: {
                jingleEl.setAttribute("responder", from.toString());
                break;
            }
        }
        this.contents.stream().map(Content::toElement).forEach(arg_0 -> ((Element)jingleEl).addChild(arg_0));
        if (!this.bundle.isEmpty()) {
            jingleEl.withElement("group", "urn:xmpp:jingle:apps:grouping:0", groupEl -> {
                groupEl.setAttribute("semantics", "BUNDLE");
                this.bundle.stream().map(name -> new Element("content", new String[]{"name"}, new String[]{name})).forEach(arg_0 -> ((Element)groupEl).addChild(arg_0));
            });
        }
        return jingleEl;
    }

    public String toString(String sid, Content.Creator localRole, Direction direction) {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("v=0");
        lines.add("o=- " + sid + " " + this.id + " IN IP4 0.0.0.0");
        lines.add("s=-");
        lines.add("t=0 0");
        if (!this.bundle.isEmpty()) {
            lines.add("a=group:BUNDLE " + this.bundle.stream().collect(Collectors.joining(" ")));
        }
        this.contents.stream().map(c -> c.toSDP(localRole, direction)).forEach(lines::add);
        return lines.stream().collect(Collectors.joining("\r\n")) + "\r\n";
    }

    public SDP applyDiff(ContentAction action, SDP diff) {
        switch (action) {
            case accept: 
            case add: {
                return new SDP(this.id, Stream.concat(this.getContents().stream(), diff.getContents().stream()).collect(Collectors.toList()), diff.getBundle());
            }
            case init: {
                return diff;
            }
            case modify: {
                Content[] contents = this.getContents().toArray(new Content[this.getContents().size()]);
                for (Content diffed : diff.getContents()) {
                    for (int i = 0; i < contents.length; ++i) {
                        if (!contents[i].getName().equals(diffed.getName())) continue;
                        contents[i] = contents[i].withSenders(diffed.getSenders()).withSSRCs(diffed.getDescription().map(Description::getSsrcs).orElse(Collections.emptyList()), diffed.getDescription().map(Description::getSsrcGroups).orElse(Collections.emptyList()));
                    }
                }
                return new SDP(this.id, new ArrayList<Content>(Arrays.asList(contents)), this.getBundle());
            }
            case remove: {
                Set toRemove = diff.getContents().stream().map(Content::getName).collect(Collectors.toSet());
                return new SDP(this.id, this.getContents().stream().filter(it -> !toRemove.contains(it.getName())).collect(Collectors.toList()), diff.getBundle());
            }
        }
        throw new UnsupportedOperationException("Unsupported content action: " + action.name());
    }

    public Map<ContentAction, SDP> diffFrom(SDP oldSdp) {
        List<Content> contentsToModify;
        List<Content> contentsToAdd;
        HashMap<ContentAction, SDP> results = new HashMap<ContentAction, SDP>();
        List oldContentNames = oldSdp.getContents().stream().map(Content::getName).collect(Collectors.toList());
        List newContentNames = this.getContents().stream().map(Content::getName).collect(Collectors.toList());
        List contentsToRemove = oldSdp.getContents().stream().filter(it -> !newContentNames.contains(it.getName())).collect(Collectors.toList());
        if (!contentsToRemove.isEmpty()) {
            SDP sdp = new SDP(this.id, contentsToRemove.stream().map(Content::cloneHeaderOnly).collect(Collectors.toList()), this.getBundle());
            results.put(ContentAction.remove, sdp);
        }
        if (!(contentsToAdd = this.getContents().stream().filter(it -> !oldContentNames.contains(it.getName())).collect(Collectors.toList())).isEmpty()) {
            results.put(ContentAction.add, new SDP(this.id, contentsToAdd, this.getBundle()));
        }
        if (!(contentsToModify = this.getContents().stream().filter(it -> oldSdp.getContents().stream().filter(oldContent -> it.getName().equals(oldContent.getName())).filter(oldContent -> it.getSenders() != oldContent.getSenders()).findFirst().isPresent()).map(Content::cloneForModify).collect(Collectors.toList())).isEmpty()) {
            results.put(ContentAction.modify, new SDP(this.id, contentsToModify, Collections.emptyList()));
        }
        return results;
    }

    public static enum Direction {
        incoming,
        outgoing;

    }
}

