/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.xml.Element;

public class Payload {
    private final int id;
    private final int channels;
    private final Optional<Integer> clockrate;
    private final Optional<Integer> maxptime;
    private final Optional<String> name;
    private final Optional<Integer> ptime;
    private final List<Parameter> parameters;
    private final List<RtcpFeedback> rtcpFeedback;

    public static Payload from(Element el) {
        if ("payload-type".equals(el.getName())) {
            String id = el.getAttributeStaticStr("id");
            if (id == null) {
                return null;
            }
            String channels = el.getAttributeStaticStr("channels");
            Optional<Integer> clockrate = Optional.ofNullable(el.getAttributeStaticStr("clockrate")).map(Integer::parseInt);
            Optional<Integer> ptime = Optional.ofNullable(el.getAttributeStaticStr("ptime")).map(Integer::parseInt);
            Optional<Integer> maxptime = Optional.ofNullable(el.getAttributeStaticStr("maxptime")).map(Integer::parseInt);
            Optional<String> name = Optional.ofNullable(el.getAttributeStaticStr("name"));
            List<Parameter> parameters = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(Parameter::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<RtcpFeedback> rtcpFeedbacks = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(RtcpFeedback::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Payload(Integer.parseInt(id), channels == null ? 1 : Integer.parseInt(channels), clockrate, maxptime, name, ptime, parameters, rtcpFeedbacks);
        }
        return null;
    }

    public Payload(int id, int channels, Optional<Integer> clockrate, Optional<Integer> maxptime, Optional<String> name, Optional<Integer> ptime, List<Parameter> parameters, List<RtcpFeedback> rtcpFeedbacks) {
        this.id = id;
        this.channels = channels;
        this.clockrate = clockrate;
        this.maxptime = maxptime;
        this.name = name;
        this.ptime = ptime;
        this.parameters = parameters;
        this.rtcpFeedback = rtcpFeedbacks;
    }

    public int getId() {
        return this.id;
    }

    public int getChannels() {
        return this.channels;
    }

    public Optional<Integer> getClockrate() {
        return this.clockrate;
    }

    public Optional<Integer> getMaxptime() {
        return this.maxptime;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Integer> getPtime() {
        return this.ptime;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<RtcpFeedback> getRtcpFeedback() {
        return this.rtcpFeedback;
    }

    public Element toElement() {
        Element el = new Element("payload-type");
        el.setAttribute("id", String.valueOf(this.id));
        if (this.channels != 1) {
            el.setAttribute("channels", String.valueOf(this.channels));
        }
        this.name.ifPresent(name -> el.setAttribute("name", name));
        this.clockrate.ifPresent(clockrate -> el.setAttribute("clockrate", String.valueOf(clockrate)));
        this.ptime.ifPresent(ptime -> el.setAttribute("ptime", String.valueOf(ptime)));
        this.maxptime.ifPresent(maxptime -> el.setAttribute("maxptime", String.valueOf(maxptime)));
        this.parameters.stream().map(Parameter::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        this.rtcpFeedback.stream().map(RtcpFeedback::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        return el;
    }

    public List<String> toSDP() {
        StringBuilder line = new StringBuilder("a=rtpmap:").append(this.id);
        this.name.ifPresent(name -> {
            line.append(" ").append((String)name);
            this.clockrate.ifPresent(clockrate -> line.append("/").append(clockrate));
            if (this.channels > 1) {
                line.append("/").append(this.channels);
            }
        });
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(line.toString());
        if (!this.parameters.isEmpty()) {
            lines.add("a=fmtp:" + this.id + " " + this.parameters.stream().map(Parameter::toSDP).collect(Collectors.joining(";")));
        }
        this.rtcpFeedback.stream().map(it -> {
            StringBuilder sb = new StringBuilder("a=rtcp-fb:").append(this.id).append(" ").append(it.type);
            it.getSubtype().ifPresent(subtype -> sb.append(" ").append((String)subtype));
            return sb.toString();
        }).forEach(lines::add);
        return lines;
    }

    public static class RtcpFeedback {
        private final String type;
        private final Optional<String> subtype;

        public static RtcpFeedback from(Element el) {
            if ("rtcp-fb".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:rtcp-fb:0".equals(el.getXMLNS())) {
                String type = el.getAttributeStaticStr("type");
                if (type == null) {
                    return null;
                }
                return new RtcpFeedback(type, Optional.ofNullable(el.getAttributeStaticStr("subtype")));
            }
            return null;
        }

        public static RtcpFeedback from(String sdp) {
            String[] parts = sdp.split(" ");
            return new RtcpFeedback(parts[0], Optional.ofNullable(parts.length > 1 ? parts[1] : null));
        }

        public RtcpFeedback(String type, Optional<String> subtype) {
            this.type = type;
            this.subtype = subtype;
        }

        public String getType() {
            return this.type;
        }

        public Optional<String> getSubtype() {
            return this.subtype;
        }

        public Element toElement() {
            Element el = new Element("rtcp-fb", new String[]{"xmlns", "type"}, new String[]{"urn:xmpp:jingle:apps:rtp:rtcp-fb:0", this.type});
            this.subtype.ifPresent(subtype -> el.setAttribute("subtype", subtype));
            return el;
        }
    }

    public static class Parameter {
        private final String name;
        private final String value;

        public static Parameter from(String sdp) {
            String[] parts = sdp.split("=");
            return new Parameter(parts[0], parts.length > 1 ? parts[1] : "");
        }

        public static Parameter from(Element el) {
            if ("parameter".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:1".equals(el.getXMLNS())) {
                String name = el.getAttributeStaticStr("name");
                String value = el.getAttributeStaticStr("value");
                if (name == null || value == null) {
                    return null;
                }
                return new Parameter(name, value);
            }
            return null;
        }

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Element toElement() {
            return new Element("parameter", new String[]{"xmlns", "name", "value"}, new String[]{"urn:xmpp:jingle:apps:rtp:1", this.name, this.value});
        }

        public String toSDP() {
            return this.name + "=" + this.value;
        }
    }
}

