/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.Publisher;

public class LocalPublisher {
    private static final Logger log = Logger.getLogger(LocalPublisher.class.getCanonicalName());
    private final JanusVideoRoomPlugin videoRoomPlugin;
    private final Object roomId;
    private final long id;
    private final long privateId;
    private final ConcurrentHashMap<Long, Publisher> publishers = new ConcurrentHashMap();
    private Listener listener;

    public static LocalPublisher fromData(Map<String, Object> data, JanusVideoRoomPlugin videoRoomPlugin, Object roomId) {
        long id = Optional.ofNullable((Number)data.get("id")).map(Number::longValue).orElseThrow(() -> new NullPointerException("Missing 'id'!"));
        long privateId = Optional.ofNullable((Number)data.get("private_id")).map(Number::longValue).orElseThrow(() -> new NullPointerException("Missing 'private_id'!"));
        return new LocalPublisher(videoRoomPlugin, roomId, id, privateId, Publisher.fromEvent((List)data.get("publishers")));
    }

    public LocalPublisher(JanusVideoRoomPlugin videoRoomPlugin, Object roomId, long id, long privateId, List<Publisher> publishers) {
        this.videoRoomPlugin = videoRoomPlugin;
        this.roomId = roomId;
        this.id = id;
        this.privateId = privateId;
        this.publishers.putAll(publishers.stream().collect(Collectors.toMap(Publisher::getId, Function.identity())));
    }

    public long getId() {
        return this.id;
    }

    public long getPrivateId() {
        return this.privateId;
    }

    public Object getRoomId() {
        return this.roomId;
    }

    public JanusSession getSession() {
        return this.videoRoomPlugin.getSession();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        if (!this.publishers.isEmpty()) {
            listener.addedPublishers(this.publishers.values());
        }
    }

    public CompletableFuture<Void> leave() {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " leaving room..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("leave", transaction, this.roomId, generator -> {}, null).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("leaving"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " failed to leave room!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " left room.");
            }
        });
    }

    public CompletableFuture<JSEP> publish(JSEP jsep) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " publishes stream..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("publish", transaction, this.roomId, generator -> {}, jsep).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("configured"))) {
                return content.jsep;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " failed to publish stream!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " published stream.");
                if (x != null) {
                    this.listener.receivedPublisherSDP((JSEP)x);
                }
            }
        });
    }

    public CompletableFuture<Void> unpublish() {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " stops publishing stream..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("unpublish", transaction, this.roomId, generator -> {}, null).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("unpublished"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " failed to stop publishing stream!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", publisher " + this.id + " stopped publishing stream.");
            }
        });
    }

    public void handleEvent(JanusVideoRoomPlugin.Content content) {
        if ("event".equals(content.getVideoRoom()) && this.roomId.equals(content.getRoom())) {
            List<Publisher> publishers = Publisher.fromEvent((List)content.data.get("publishers"));
            if (publishers != null) {
                this.publishers.putAll(publishers.stream().collect(Collectors.toMap(Publisher::getId, Function.identity())));
                if (this.listener != null) {
                    this.listener.addedPublishers(publishers);
                }
            } else if (content.data.containsKey("unpublished")) {
                Optional.ofNullable(content.data.get("unpublished")).filter(Number.class::isInstance).map(Number.class::cast).ifPresent(id -> {
                    this.publishers.remove(id.longValue());
                    if (this.listener != null) {
                        this.listener.removedPublishers(id.longValue());
                    }
                });
            }
        }
    }

    public Collection<Publisher> getPublishers() {
        return this.publishers.values();
    }

    public CompletableFuture<Void> sendCandidate(JanusPlugin.Candidate candidate) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", sending candidate " + candidate + "..");
        return this.videoRoomPlugin.sendTrickle(transaction, candidate).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to send candidate!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", candidate sent.");
            }
        });
    }

    public void receivedCandidate(JanusPlugin.Candidate candidate) {
        this.listener.receivedPublisherCandidate(candidate);
    }

    public static interface Listener {
        public void addedPublishers(Collection<Publisher> var1);

        public void removedPublishers(long var1);

        public void receivedPublisherSDP(JSEP var1);

        public void receivedPublisherCandidate(JanusPlugin.Candidate var1);
    }
}

