/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;

public class JanusVideoRoomPlugin
extends JanusPlugin<Content> {
    public static final String ID = "janus.plugin.videoroom";
    private static final Logger log = Logger.getLogger(JanusVideoRoomPlugin.class.getCanonicalName());
    private LocalPublisher localPublisher;
    private LocalSubscriber localSubscriber;

    public JanusVideoRoomPlugin(JanusSession session, Map<String, Object> data) {
        super(session, data);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handleEvent(Content content) {
        log.log(Level.FINER, this.toString() + ", received event with: " + content.data + " and jsep " + content.jsep);
        if (this.localPublisher != null) {
            this.localPublisher.handleEvent(content);
        }
        if (this.localSubscriber != null) {
            this.localSubscriber.handleEvent(content);
        }
    }

    @Override
    protected void receivedCandidate(JanusPlugin.Candidate candidate) {
        if (this.localPublisher != null) {
            this.localPublisher.receivedCandidate(candidate);
        }
        if (this.localSubscriber != null) {
            this.localSubscriber.receivedCandidate(candidate);
        }
    }

    public CompletableFuture<Object> createRoom(Object roomId, int maxNoOfPublishers) {
        String transaction = this.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + " creating room " + roomId + "...");
        return ((CompletableFuture)this.execute("create", transaction, roomId, generator -> {
            generator.writeNumberField("publishers", maxNoOfPublishers);
            generator.writeBooleanField("notify_joining", true);
        }, null).thenApply(content -> {
            String videoroom;
            switch (videoroom = content.getVideoRoom()) {
                case "created": {
                    return content.getRoom();
                }
            }
            throw new UnsupportedOperationException("Unsupported response '" + videoroom + "'");
        })).whenComplete((room, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", room " + roomId + " creation failed!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", room " + roomId + " created.");
            }
        });
    }

    public CompletableFuture<Void> destroyRoom(Object roomId) {
        String transaction = this.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", destroying room..");
        return ((CompletableFuture)this.execute("destroy", transaction, roomId, generator -> {}, null).thenAccept(data -> {
            String videoroom;
            switch (videoroom = data.getVideoRoom()) {
                case "destroyed": {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported response '" + videoroom + "'");
                }
            }
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to destruct room!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", room destroyed.");
            }
        });
    }

    public CompletableFuture<LocalPublisher> createPublisher(Object roomId, String displayName) {
        String transaction = this.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", joining as publisher..");
        return ((CompletableFuture)this.execute("join", transaction, roomId, generator -> {
            generator.writeStringField("ptype", "publisher");
            if (displayName != null) {
                generator.writeStringField("display", displayName);
            }
        }, null).thenApply(data -> {
            if ("joined".equals(data.getVideoRoom())) {
                return LocalPublisher.fromData(data.data, this, roomId);
            }
            throw new UnsupportedOperationException("Unexpected response: " + data);
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to join as publisher!");
            } else {
                JanusVideoRoomPlugin janusVideoRoomPlugin = this;
                synchronized (janusVideoRoomPlugin) {
                    this.localPublisher = x;
                }
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", joined as publisher.");
            }
        });
    }

    public synchronized LocalSubscriber createSubscriber(Object roomId) {
        this.localSubscriber = new LocalSubscriber(this, roomId);
        return this.localSubscriber;
    }

    public CompletableFuture<Content> execute(String request, String transaction, Object roomId, JanusConnection.RequestGenerator requestGenerator, JSEP jsep) {
        return this.execute(transaction, generator -> {
            generator.writeStringField("request", request);
            if (roomId != null) {
                if (roomId instanceof Number) {
                    generator.writeNumberField("room", ((Number)roomId).longValue());
                } else {
                    generator.writeStringField("room", roomId.toString());
                }
            }
            requestGenerator.accept(generator);
        }, jsep);
    }

    public CompletableFuture<Void> sendMessage(String request, String transaction, Object roomId, JanusConnection.RequestGenerator requestGenerator, JSEP jsep) {
        return this.sendMessage(transaction, generator -> {
            generator.writeStringField("request", request);
            if (roomId != null) {
                if (roomId instanceof Number) {
                    generator.writeNumberField("room", ((Number)roomId).longValue());
                } else {
                    generator.writeStringField("room", roomId.toString());
                }
            }
            requestGenerator.accept(generator);
        }, jsep);
    }

    @Override
    protected Content newContent(Map<String, Object> data, JSEP jsep) {
        return new Content((Map)data, jsep);
    }

    public static class Content
    extends JanusPlugin.Content {
        public Content(Map data, JSEP jsep) {
            super(data, jsep);
        }

        public Object getRoom() {
            Object room = this.data.get("room");
            if (room instanceof Number) {
                return ((Number)room).longValue();
            }
            return room;
        }

        public String getVideoRoom() {
            return Optional.ofNullable((String)this.data.get("videoroom")).orElseThrow(() -> new NullPointerException("Missing 'videoroom'!"));
        }
    }

    public static class Stream {
        public final long feedId;
        public final String mid;

        public Stream(long feedId, String mid) {
            this.feedId = feedId;
            this.mid = mid;
        }

        public long getFeed() {
            return this.feedId;
        }

        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("feed", this.feedId);
            if (this.mid != null) {
                generator.writeStringField("mid", this.mid);
            }
            generator.writeEndObject();
        }
    }
}

