/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import tigase.meet.AbstractMeet;
import tigase.meet.AbstractParticipation;
import tigase.meet.Session;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.xmpp.jid.JID;

public abstract class AbstractParticipationWithSession<P extends AbstractParticipationWithSession<P, M>, M extends AbstractMeet<P>>
extends AbstractParticipation<P, M> {
    private static final Logger log = Logger.getLogger(AbstractParticipationWithSession.class.getCanonicalName());
    private final JID jid;
    private Optional<Session> subscriberSession = Optional.empty();
    private Optional<Session> publisherSession = Optional.empty();

    public AbstractParticipationWithSession(M meet, JID jid, LocalPublisher localPublisher, LocalSubscriber localSubscriber) {
        super(meet, localPublisher, localSubscriber);
        this.jid = jid;
    }

    public JID getJid() {
        return this.jid;
    }

    public synchronized Optional<Session> getPublisherSession() {
        return this.publisherSession;
    }

    public Optional<String> getPublisherSessionId() {
        return this.publisherSession.map(Session::getId);
    }

    public synchronized Optional<Session> getSubscriberSession() {
        return this.subscriberSession;
    }

    public Optional<String> getSubscriberSessionId() {
        return this.subscriberSession.map(Session::getId);
    }

    public synchronized void startSubscriberSession(String subscriberSessionId) {
        this.subscriberSession = Optional.of(new Session(subscriberSessionId));
    }

    public synchronized void startPublisherSession(String publisherSessionId) {
        this.publisherSession = Optional.of(new Session(publisherSessionId));
    }

    public synchronized void terminateSubscriberSession() {
        this.subscriberSession = Optional.empty();
    }

    public synchronized void terminatePublisherSession() {
        this.publisherSession = Optional.empty();
    }

    @Override
    public void receivedPublisherSDP(JSEP jsep) {
        this.getPublisherSessionId().ifPresent(sessionId -> this.receivedPublisherSDP((String)sessionId, jsep));
    }

    protected abstract void receivedPublisherSDP(String var1, JSEP var2);

    @Override
    public void receivedPublisherCandidate(JanusPlugin.Candidate candidate) {
        this.getPublisherSessionId().ifPresent(sessionId -> this.receivedPublisherCandidate((String)sessionId, candidate));
    }

    protected abstract void receivedPublisherCandidate(String var1, JanusPlugin.Candidate var2);

    @Override
    public synchronized void receivedSubscriberSDP(JSEP jsep) {
        if (this.getSubscriberSessionId().isEmpty()) {
            this.startSubscriberSession(UUID.randomUUID().toString());
        }
        this.getSubscriberSessionId().ifPresent(sessionId -> this.receivedSubscriberSDP((String)sessionId, jsep));
    }

    protected abstract void receivedSubscriberSDP(String var1, JSEP var2);

    @Override
    public void receivedSubscriberCandidate(JanusPlugin.Candidate candidate) {
        this.getSubscriberSessionId().ifPresent(sessionId -> this.receivedSubscriberCandidate((String)sessionId, candidate));
    }

    protected abstract void receivedSubscriberCandidate(String var1, JanusPlugin.Candidate var2);

    @Override
    public synchronized CompletableFuture<Void> leave(Throwable ex) {
        this.terminatePublisherSession();
        this.terminateSubscriberSession();
        return super.leave(ex);
    }

    @Override
    public String toString() {
        return "AbstractParticipationWithSession{jid=" + this.jid + ", meet=" + this.getMeet() + "}";
    }
}

