/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.util;

import java.io.Writer;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.importexport.AbstractImporterExtension;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.ImporterExtension;
import tigase.db.util.importexport.RepositoryManager;
import tigase.mix.IMixComponent;
import tigase.pubsub.modules.mam.ExtendedQueryImpl;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.utils.PubSubRepositoryManagerExtension;
import tigase.server.Message;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MIXRepositoryManagerExtension
extends PubSubRepositoryManagerExtension {
    private static final Logger log = Logger.getLogger(PubSubRepositoryManagerExtension.class.getSimpleName());
    private final CommandlineParameter INCLUDE_MIX = new CommandlineParameter.Builder(null, "include-mix").type(Boolean.class).description("Include MIX component data").defaultValue("false").requireArguments(false).build();

    public Stream<CommandlineParameter> getImportParameters() {
        return Stream.of(this.INCLUDE_MIX);
    }

    public Stream<CommandlineParameter> getExportParameters() {
        return Stream.of(this.INCLUDE_MIX, Exporter.EXPORT_MAM_SINCE);
    }

    public void exportDomainData(String domain, Writer writer) throws Exception {
        if (!RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_MIX)) {
            return;
        }
        List names = this.getNamesOfComponent(IMixComponent.class);
        log.finest("for domain " + domain + " found following MIX components: " + names);
        for (String name : names) {
            BareJID rootServiceJID = BareJID.bareJIDInstance((String)(name + "." + domain));
            PubSubDAO pubSubDAO = (PubSubDAO)this.getRepository(PubSubDAO.class, rootServiceJID.getDomain());
            HashSet publicServiceJIDs = new HashSet(pubSubDAO.getServices(rootServiceJID, Boolean.valueOf(true)));
            List serviceJIDs = pubSubDAO.getServices(rootServiceJID, null);
            if (serviceJIDs == null || serviceJIDs.isEmpty()) continue;
            Path mixComponentFile = this.getRootPath().resolve(rootServiceJID.getDomain() + ".xml");
            log.info("exporting MIX data for component domain " + name + "." + domain + "..");
            this.exportInclude(writer, mixComponentFile, pubsubWriter -> {
                pubsubWriter.append("<mix xmlns=\"tigase:xep-0227:mix:0\" name=\"").append(name).append("\">\n");
                for (BareJID serviceJID : serviceJIDs) {
                    this.exportInclude((Writer)pubsubWriter, mixComponentFile.resolveSibling(rootServiceJID.getDomain()).resolve(serviceJID.getLocalpart() + ".xml"), channelWriter -> {
                        boolean isPublic = publicServiceJIDs.contains(serviceJID);
                        channelWriter.append("<channel name=\"").append(serviceJID.getLocalpart()).append("\" public=\"").append(String.valueOf(isPublic)).append("\">\n");
                        this.exportData(serviceJID, false, (Writer)channelWriter);
                        channelWriter.append("\n</channel>");
                    });
                }
                pubsubWriter.append("</mix>");
            });
        }
    }

    public void exportUserData(Path userDirPath, BareJID serviceJid, Writer writer) throws Exception {
    }

    public ImporterExtension startImportDomainData(String domain, String name, Map<String, String> attrs) throws Exception {
        if (!"mix".equals(name) || !"tigase:xep-0227:mix:0".equals(attrs.get("xmlns"))) {
            return null;
        }
        String prefix = attrs.get("name");
        String subdomain = prefix == null ? domain : prefix + "." + domain;
        return new MIXImporterExtension((PubSubDAO)this.getRepository(PubSubDAO.class, subdomain), subdomain, RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_MIX));
    }

    public static class MIXImporterExtension
    extends AbstractImporterExtension {
        private final String domain;
        private final boolean includeMIX;
        private final PubSubDAO pubSubDAO;
        private BareJID channel;
        private ImporterExtension activeExtension = null;
        private final HashSet<BareJID> existingChannels;
        private int depth;

        public MIXImporterExtension(PubSubDAO pubSubDAO, String domain, boolean includeMIX) throws RepositoryException {
            this.pubSubDAO = pubSubDAO;
            this.domain = domain;
            this.includeMIX = includeMIX;
            if (includeMIX) {
                log.info("importing MIX data for component domain " + domain + "...");
            }
            this.existingChannels = new HashSet(pubSubDAO.getServices(BareJID.bareJIDInstanceNS((String)domain), null));
        }

        public boolean startElement(String name, Map<String, String> attrs) throws Exception {
            if (!this.includeMIX) {
                ++this.depth;
                return true;
            }
            if (this.channel != null) {
                if (this.activeExtension != null) {
                    return this.activeExtension.startElement(name, attrs);
                }
                if (!"pubsub".equals(name)) {
                    return false;
                }
                this.activeExtension = switch (attrs.get("xmlns")) {
                    case "http://jabber.org/protocol/pubsub#owner" -> new PubSubRepositoryManagerExtension.PubSubOwnerImporterExtension(this.pubSubDAO, this.channel, false);
                    case "http://jabber.org/protocol/pubsub" -> new PubSubRepositoryManagerExtension.PubSubDataImporterExtension(this.pubSubDAO, this.channel, false, MIXMAMImporterExtension.class);
                    default -> null;
                };
                return this.activeExtension != null;
            }
            if ("channel".equals(name)) {
                this.channel = BareJID.bareJIDInstance((String)attrs.get("name"), (String)this.domain);
                boolean isPublic = Boolean.parseBoolean(attrs.get("public"));
                if (this.existingChannels.add(this.channel)) {
                    this.pubSubDAO.createService(this.channel, isPublic);
                } else {
                    log.finest("MIX channel " + this.channel + ", already existed");
                }
                return true;
            }
            return false;
        }

        public boolean handleElement(Element element) throws Exception {
            return this.activeExtension != null && this.activeExtension.handleElement(element);
        }

        public boolean endElement(String name) throws Exception {
            if (!this.includeMIX) {
                ++this.depth;
                return true;
            }
            if (this.activeExtension != null && this.activeExtension.endElement(name)) {
                return true;
            }
            if (this.activeExtension != null && "pubsub".equals(name)) {
                this.activeExtension.close();
                this.activeExtension = null;
                return true;
            }
            if ("channel".equals(name)) {
                this.channel = null;
                return true;
            }
            return false;
        }
    }

    public static class MIXMAMImporterExtension
    extends PubSubRepositoryManagerExtension.PubSubMAMImporterExtension {
        public MIXMAMImporterExtension(PubSubDAO pubSubDAO, BareJID serviceJID, String nodeName) throws RepositoryException {
            super(pubSubDAO, serviceJID, nodeName);
        }

        protected boolean handleMessage(Message message, String stableId, Date timestamp, Element source) throws Exception {
            if ("urn:xmpp:mix:nodes:messages".equals(this.nodeName)) {
                PubSubQuery query = this.pubSubDAO.newQuery(this.serviceJID);
                if (query instanceof ExtendedQueryImpl) {
                    ExtendedQueryImpl extendedQuery = (ExtendedQueryImpl)query;
                    query.setPubsubNode(this.nodeName);
                    query.setComponentJID(JID.jidInstance((BareJID)this.serviceJID));
                    query.setQuestionerJID(JID.jidInstance((BareJID)this.serviceJID));
                    extendedQuery.setIds(List.of(stableId));
                    AtomicBoolean found = new AtomicBoolean(false);
                    try {
                        this.pubSubDAO.queryItems(query, this.nodeMeta.getNodeId(), (query1, item) -> found.set(true));
                        if (found.get()) {
                            log.finest("skipping inserting MAM item for " + this.serviceJID + ", node = " + this.nodeName + ", stable id = " + stableId);
                            return true;
                        }
                    }
                    catch (ComponentException ex) {
                        if (ex.getErrorCondition() == Authorization.ITEM_NOT_FOUND) {
                            this.pubSubDAO.addMAMItem(this.serviceJID, this.nodeMeta.getNodeId(), stableId, message.getElement(), timestamp, null);
                        }
                        throw ex;
                    }
                }
                return true;
            }
            return super.handleMessage(message, stableId, timestamp, source);
        }
    }
}

