/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Set;
import java.util.stream.Stream;
import tigase.stats.StatisticHolder;

public interface Cache<K, V>
extends StatisticHolder {
    public V computeIfAbsent(K var1, CacheSupplier<V> var2) throws CacheException;

    public V get(K var1);

    public V put(K var1, V var2);

    public V putIfAbsent(K var1, V var2);

    public V remove(K var1);

    public Set<K> keySet();

    public Stream<V> values();

    public int size();

    public void setMaxSize(int var1);

    public static class CacheException
    extends Exception {
        public CacheException(Throwable ex) {
            super(ex.getMessage(), ex);
        }
    }

    @FunctionalInterface
    public static interface CacheSupplier<V> {
        public V get() throws CacheException;
    }
}

