/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.MeetComponentClustered;
import tigase.meet.cluster.StrategyIfc;
import tigase.meet.cluster.commands.MeetCreationLockCommand;
import tigase.meet.cluster.commands.MeetSyncRequestCommand;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.util.common.TimerTask;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="meetStrategy", parent=MeetComponentClustered.class, active=true)
public class DefaultStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(DefaultStrategy.class.getCanonicalName());
    private final ConcurrentHashMap<BareJID, JID> b = new ConcurrentHashMap();
    private final ConcurrentHashMap<a, CompletableFuture<Void>> c = new ConcurrentHashMap();
    private final ConcurrentHashMap<BareJID, TimerTask> d = new ConcurrentHashMap();
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject(bean="clusterController", nullAllowed=true)
    private ClusterControllerIfc cl_controller;
    private JID e;

    @Override
    public CompletableFuture<Void> acquireMeetCreationLock(BareJID meetJid) {
        long l = System.currentTimeMillis() + this.getCreationLockTimeout();
        a.log(Level.FINEST, () -> "trying to acquire cluster wide lock for " + meetJid);
        if (!this.createMeetCreationLock(meetJid, l, this.getLocalNodeJid())) {
            a.log(Level.FINEST, () -> "failed to acquire cluster wide lock for " + meetJid + ", it is already locked locally");
            return CompletableFuture.failedFuture((Throwable)new ComponentException(Authorization.CONFLICT, "Meet creation request in progress!"));
        }
        List list = this.component.getNodesConnected();
        ArrayList<CompletionStage> arrayList = new ArrayList<CompletionStage>();
        for (JID jID : list) {
            CompletableFuture completableFuture = new CompletableFuture();
            arrayList.add(completableFuture.whenComplete((void_, throwable) -> {
                if (throwable != null) {
                    a.log(Level.FINEST, (Throwable)throwable, () -> "node " + jID + " rejected lock creation for " + meetJid);
                } else {
                    a.log(Level.FINEST, () -> "node " + jID + " confirmed lock creation for " + meetJid);
                }
            }));
            this.c.put(new a(meetJid, jID), completableFuture);
        }
        a.log(Level.FINEST, () -> "send lock acquire requests for " + meetJid + " to " + list + " with timeout on " + l);
        MeetCreationLockCommand.acquireLock(this, meetJid, list, l);
        return CompletableFuture.allOf((CompletableFuture[])arrayList.toArray(CompletableFuture[]::new)).orTimeout(l - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void releaseMeetCreationLock(BareJID meetJid, boolean success) {
        TimerTask timerTask;
        if (!success) {
            a.log(Level.FINEST, () -> "removing mapping of " + meetJid + " to node " + this.getLocalNodeJid() + " - local failure");
            this.b.remove(meetJid, this.getLocalNodeJid());
        }
        if ((timerTask = this.d.remove(meetJid)) != null) {
            timerTask.cancel();
        }
        a.log(Level.FINEST, () -> "send lock release requests for " + meetJid + " to " + this.component.getNodesConnected());
        MeetCreationLockCommand.releaseLock(this, meetJid, this.component.getNodesConnected(), success);
        this.c.entrySet().removeIf(entry -> ((a)entry.getKey()).b.equals((Object)meetJid));
    }

    @Override
    public ClusterControllerIfc getClusterController() {
        return this.cl_controller;
    }

    @Override
    public long getCreationLockTimeout() {
        return 60000L;
    }

    @Override
    public JID getLocalNodeJid() {
        return this.e;
    }

    @Override
    public JID getNodeForPacket(Packet packet) throws ComponentException {
        JID jID = Optional.ofNullable(packet.getStanzaTo()).orElseThrow(() -> new ComponentException(Authorization.NOT_ACCEPTABLE, "Missing 'to' attribute in stanza!"));
        return this.getNodeForMeet(jID.getBareJID());
    }

    @Override
    public void nodeConnected(JID nodeJid) {
        if (!this.e.equals((Object)nodeJid)) {
            this.requestSync(nodeJid);
        }
    }

    @Override
    public Stream<BareJID> streamLocalMeets() {
        JID jID = this.getLocalNodeJid();
        return this.b.entrySet().stream().filter(entry -> jID.equals(entry.getValue())).map(entry -> (BareJID)entry.getKey());
    }

    @Override
    public void nodeDisconnected(JID jid) {
        this.b.values().removeIf(jID2 -> jID2.equals((Object)jid));
    }

    protected void requestSync(JID jid) {
        MeetSyncRequestCommand.request(this, jid);
    }

    @Override
    public void setMeetToNodeMapping(BareJID meetJid, JID jid) {
        a.log(Level.FINEST, () -> "setting mapping of " + meetJid + " to node " + jid + " - timeout");
        this.b.put(meetJid, jid);
    }

    @Override
    public void removeMeetToNodeMapping(BareJID meetJid, JID jid) {
        this.b.remove(meetJid, jid);
    }

    public JID getNodeForMeet(BareJID meetJid) {
        return Optional.ofNullable(this.b.get(meetJid)).orElse(this.getLocalNodeJid());
    }

    public AbstractMessageReceiver getComponent() {
        return this.component;
    }

    public void setComponent(AbstractMessageReceiver component) {
        this.component = component;
        this.e = JID.jidInstanceNS((String)component.getName(), (String)component.getDefHostName().getDomain(), null);
    }

    @Override
    public boolean createMeetCreationLock(final BareJID meetJid, long time, final JID node) {
        JID jID = this.b.putIfAbsent(meetJid, node);
        if (jID != null) {
            return false;
        }
        TimerTask timerTask = new TimerTask(){

            public void run() {
                a.log(Level.FINEST, () -> "removing mapping of " + meetJid + " to node " + node + " - timeout");
                DefaultStrategy.this.b.remove(meetJid, node);
            }
        };
        this.d.put(meetJid, timerTask);
        this.component.addTimerTask(timerTask, time - System.currentTimeMillis());
        return true;
    }

    @Override
    public void acquiredMeetCreationLock(BareJID meetJid, JID node, boolean result) {
        CompletableFuture<Void> completableFuture = this.c.remove(new a(meetJid, node));
        if (completableFuture != null) {
            if (result) {
                completableFuture.complete(null);
            } else {
                completableFuture.completeExceptionally((Throwable)new ComponentException(Authorization.CONFLICT));
            }
        }
    }

    @Override
    public void releasedMeetCreationLock(BareJID meetJid, JID node, boolean success) {
        TimerTask timerTask;
        if (!success) {
            a.log(Level.FINEST, () -> "removing mapping of " + meetJid + " to node " + node + " - failure");
            this.b.remove(meetJid, node);
        }
        if ((timerTask = this.d.remove(new a(meetJid, node))) != null) {
            timerTask.cancel();
        }
    }

    @Override
    public int getMeetsCount() {
        return this.b.size();
    }

    class a {
        private final BareJID b;
        private final JID c;

        a(BareJID bareJID, JID jID) {
            this.b = bareJID;
            this.c = jID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof a)) {
                return false;
            }
            a a2 = (a)o;
            return this.b.equals((Object)a2.b) && this.c.equals((Object)a2.c);
        }

        public int hashCode() {
            return Objects.hash(this.b, this.c);
        }
    }
}

