/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;

public class StatisticsData {
    private static final Logger b = Logger.getLogger(StatisticsData.class.getCanonicalName());
    private static final String c = "statistics";
    private static final String d = "timestamp";
    public static final String[] TIMESTAMP_PATH = new String[]{"statistics", "timestamp"};
    private static final String e = "domain";
    public static final String[] DOMAIN_PATH = new String[]{"statistics", "domain"};
    private static final String f = "installation_id";
    public static final String[] INSTALLATION_ID_ELEM_NAME_PATH = new String[]{"statistics", "installation_id"};
    private static final String g = "installation-id";
    static final String[] a = new String[]{"installation-id"};
    private static final String h = "version";
    public static final String[] VERSION_ELEM_NAME_ELEM_NAME_PATH = new String[]{"statistics", "version"};
    private static final String i = "vhosts";
    public static final String[] VHOSTS_ITEM_PATH = new String[]{"statistics", "vhosts"};
    private static final String j = "uptime";
    public static final String[] UPTIME_PATH = new String[]{"statistics", "uptime"};
    private static final String k = "heap";
    private static final String l = "item";
    private static final String m = "max";
    public static final String[] HEAP_MAX_PATH = new String[]{"statistics", "heap", "max"};
    private static final String n = "used";
    public static final String[] HEAP_USED_PATH = new String[]{"statistics", "heap", "used"};
    private static final String o = "users";
    private static final String p = "online";
    public static final String[] USERS_ONLINE_PATH = new String[]{"statistics", "users", "online"};
    private static final String q = "active";
    public static final String[] USERS_ACTIVE_PATH = new String[]{"statistics", "users", "active"};
    private static final String r = "cluster";
    private static final String s = "nodes_count";
    public static final String[] CLUSTER_NODES_COUNT_PATH = new String[]{"statistics", "cluster", "nodes_count"};
    private static final String t = "additional_data";
    public static final String[] ADDITIONAL_DATA_PATH = new String[]{"statistics", "additional_data"};
    private static final String u = "max_today";
    public static final String[] MAX_SESSIONS_TODAY_PATH = new String[]{"statistics", "users", "max_today"};
    private static final String v = "max_yesterday";
    public static final String[] MAX_SESSIONS_YESTERDAY_PATH = new String[]{"statistics", "users", "max_yesterday"};
    private static final SimpleDateFormat w = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected static int VERSION = 1;
    private final BareJID x;
    private Date y;
    private String z;
    private int A;
    private long B;
    private long C;
    private long D;
    private long E;
    private long F;
    private long G;
    private long H;
    private String I = null;
    private String J = null;
    private List<BareJID> K;
    private static final BareJID L = BareJID.bareJIDInstanceNS((String)"default");
    private static final SimpleParser M = new SimpleParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticsData fromElement(Element element) throws TigaseStringprepException {
        Object object;
        b.log(Level.FINEST, "element = " + element);
        if (element.getName() != c) {
            throw new IllegalArgumentException("Invalid element passed, elem = " + element.toString());
        }
        int n = Integer.parseInt(element.getAttributeStaticStr(h));
        if (n != VERSION) {
            throw new IllegalArgumentException("Invalid version, expected " + VERSION + " got " + n);
        }
        b.log(Level.FINEST, "version = " + n);
        BareJID bareJID = null;
        String string = element.getChildCData(DOMAIN_PATH);
        if (string != null) {
            bareJID = BareJID.bareJIDInstance((String)string);
        }
        b.log(Level.FINEST, "domain = " + bareJID);
        Date date = null;
        String string2 = element.getChildCData(TIMESTAMP_PATH);
        Object object2 = w;
        synchronized (object2) {
            try {
                date = w.parse(string2);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        b.log(Level.FINEST, "timestamp = " + date);
        object2 = new StatisticsData(bareJID, date);
        List list = element.getChildren(VHOSTS_ITEM_PATH);
        b.log(Level.FINEST, "vhosts = " + Arrays.asList(list));
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            String[] stringArray;
            object = (Element)object3.next();
            String string3 = object.getCData();
            if (string3.startsWith("[") && string3.endsWith("]")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (string3.contains(",") && string3.contains(" ")) {
                for (String string4 : stringArray = string3.split(",")) {
                    BareJID bareJID2 = BareJID.bareJIDInstance((String)string4.trim());
                    ((StatisticsData)object2).addVHost(bareJID2);
                }
                continue;
            }
            stringArray = BareJID.bareJIDInstance((String)string3);
            ((StatisticsData)object2).addVHost((BareJID)stringArray);
        }
        b.log(Level.FINEST, "data.vhosts = " + Arrays.asList(((StatisticsData)object2).K));
        ((StatisticsData)object2).F = Long.parseLong(element.getCData(UPTIME_PATH));
        ((StatisticsData)object2).C = Long.parseLong(element.getCData(HEAP_USED_PATH));
        ((StatisticsData)object2).B = Long.parseLong(element.getCData(HEAP_MAX_PATH));
        ((StatisticsData)object2).A = Integer.parseInt(element.getCData(CLUSTER_NODES_COUNT_PATH));
        ((StatisticsData)object2).H = Long.parseLong(element.getCData(USERS_ONLINE_PATH));
        ((StatisticsData)object2).G = Long.parseLong(element.getCData(USERS_ACTIVE_PATH));
        ((StatisticsData)object2).z = element.getCData(ADDITIONAL_DATA_PATH);
        if (((StatisticsData)object2).z != null) {
            ((StatisticsData)object2).z = XMLUtils.unescape((String)((StatisticsData)object2).z);
        }
        ((StatisticsData)object2).I = element.getCData(INSTALLATION_ID_ELEM_NAME_PATH);
        ((StatisticsData)object2).J = element.getCData(VERSION_ELEM_NAME_ELEM_NAME_PATH);
        if ((((StatisticsData)object2).I == null || ((StatisticsData)object2).J == null) && ((StatisticsData)object2).z != null) {
            object3 = new DomBuilderHandler();
            M.parse((SimpleHandler)object3, ((StatisticsData)object2).z);
            object = object3.getParsedElements();
            if (!object.isEmpty()) {
                if (((StatisticsData)object2).I == null) {
                    StatisticsData.b((Queue<Element>)object).ifPresent(arg_0 -> StatisticsData.a((StatisticsData)object2, arg_0));
                }
                if (((StatisticsData)object2).J == null) {
                    StatisticsData.a((Queue<Element>)object).ifPresent(arg_0 -> StatisticsData.a((StatisticsData)object2, arg_0));
                }
            }
        }
        ((StatisticsData)object2).D = (object3 = element.getCData(MAX_SESSIONS_TODAY_PATH)) == null ? -1L : Long.parseLong((String)object3);
        object3 = element.getCData(MAX_SESSIONS_YESTERDAY_PATH);
        ((StatisticsData)object2).E = object3 == null ? -1L : Long.parseLong((String)object3);
        return object2;
    }

    private static Optional<String> a(Queue<Element> queue) {
        return queue.stream().filter(element -> "components".equals(element.getName())).flatMap(element -> element.getChildren().stream()).filter(element -> element.getChild("name").getCData().equals("sess-man")).findAny().map(element -> element.getCData(new String[]{"cmpInfo", h}));
    }

    private static Optional<Element> b(Queue<Element> queue) {
        return queue.stream().filter(element -> g.equals(element.getName())).findFirst();
    }

    public StatisticsData(BareJID domain) {
        this(domain, new Date());
    }

    private StatisticsData(BareJID domain, Date timestamp) {
        this.x = domain;
        this.y = timestamp;
        this.K = new ArrayList<BareJID>();
    }

    public int getVersion() {
        return VERSION;
    }

    public BareJID getDomain() {
        return this.x;
    }

    public Date getTimestamp() {
        return this.y;
    }

    public void setTimestamp(Date timestamp) {
        this.y = timestamp;
    }

    public List<BareJID> getVHosts() {
        return Collections.unmodifiableList(this.K);
    }

    public void addVHost(BareJID vhost) {
        if (!L.equals((Object)vhost)) {
            this.K.add(vhost);
        }
    }

    public void addVHosts(Collection<BareJID> vhosts) {
        if (vhosts != null) {
            vhosts.forEach(this::addVHost);
        }
    }

    public long getUptime() {
        return this.F;
    }

    public long getUptimeAsDays() {
        return this.F / 86400000L;
    }

    public void setUptime(long uptime) {
        this.F = uptime;
    }

    public long getHeapUsed() {
        return this.C;
    }

    public void setHeapUsed(long heapUsed) {
        this.C = heapUsed;
    }

    public long getHeapMax() {
        return this.B;
    }

    public void setHeapMax(long heapMax) {
        this.B = heapMax;
    }

    public int getClusterNodesCount() {
        return this.A;
    }

    public void setClusterNodesCount(int clusterNodesCount) {
        this.A = clusterNodesCount;
    }

    public long getUsersActive() {
        return this.G;
    }

    public void setUsersActive(long usersActive) {
        this.G = usersActive;
    }

    public long getUsersOnline() {
        return this.H;
    }

    public void setUsersOnline(long usersOnline) {
        this.H = usersOnline;
    }

    public String getAdditionalData() {
        return this.z;
    }

    public void setAdditionalData(String additionalData) {
        this.z = additionalData;
    }

    public Element toElement() {
        return this.toElement(true);
    }

    public String getInstallation_id() {
        return this.I;
    }

    public void setInstallation_id(String installation_id) {
        this.I = installation_id;
    }

    public String getInstallation_version() {
        return this.J;
    }

    public void setInstallation_version(String installation_version) {
        this.J = installation_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toElement(boolean escape) {
        BareJID bareJID2;
        Element element = new Element(c);
        element.setAttribute(h, String.valueOf(this.getVersion()));
        element.addChild((XMLNodeIfc)new Element(e, this.x.toString()));
        if (this.I != null) {
            element.addChild((XMLNodeIfc)new Element(f, this.I));
        }
        if (this.J != null) {
            element.addChild((XMLNodeIfc)new Element(h, this.J));
        }
        String string = null;
        SimpleDateFormat simpleDateFormat = w;
        synchronized (simpleDateFormat) {
            string = w.format(this.y);
        }
        element.addChild((XMLNodeIfc)new Element(d, string));
        if (!this.K.isEmpty()) {
            simpleDateFormat = new Element(i);
            for (BareJID bareJID2 : this.K) {
                simpleDateFormat.addChild((XMLNodeIfc)new Element(l, bareJID2.toString()));
            }
            element.addChild((XMLNodeIfc)simpleDateFormat);
        }
        element.addChild((XMLNodeIfc)new Element(j, String.valueOf(this.F)));
        simpleDateFormat = new Element(k);
        simpleDateFormat.addChild((XMLNodeIfc)new Element(n, String.valueOf(this.C)));
        simpleDateFormat.addChild((XMLNodeIfc)new Element(m, String.valueOf(this.B)));
        element.addChild((XMLNodeIfc)simpleDateFormat);
        Element element2 = new Element(r);
        element2.addChild((XMLNodeIfc)new Element(s, String.valueOf(this.A)));
        element.addChild((XMLNodeIfc)element2);
        bareJID2 = new Element(o);
        bareJID2.addChild((XMLNodeIfc)new Element(p, String.valueOf(this.H)));
        bareJID2.addChild((XMLNodeIfc)new Element(q, String.valueOf(this.G)));
        bareJID2.addChild((XMLNodeIfc)new Element(u, String.valueOf(this.D)));
        bareJID2.addChild((XMLNodeIfc)new Element(v, String.valueOf(this.E)));
        element.addChild((XMLNodeIfc)bareJID2);
        if (this.z != null && !this.z.isEmpty()) {
            Element element3 = new Element(t);
            if (escape) {
                element3.setCData(XMLUtils.escape((String)this.z));
            } else {
                element3.setCData(this.z);
            }
            element.addChild((XMLNodeIfc)element3);
        }
        return element;
    }

    public long getMaxSessionsYesterday() {
        return this.E;
    }

    public void setMaxSessionsYesterday(long maxSessionsYesterday) {
        this.E = maxSessionsYesterday;
    }

    public boolean isTestSDRequest() {
        return this.x != null && "example.com".equals(this.x.toString()) && this.F == 10000L && this.C == 0xA00000L && this.B == 0x6400000L && this.A == 4 && this.H == 1000L && this.G == 100L && this.z == null && this.D == 0L && this.E == 0L && this.K != null && this.K.size() == 2 && new HashSet<BareJID>(this.K).containsAll(Set.of(BareJID.bareJIDInstanceNS((String)"test1.com"), BareJID.bareJIDInstanceNS((String)"test2.com")));
    }

    public long getMaxSessionsToday() {
        return this.D;
    }

    public void setMaxSessionsToday(long maxSessionsToday) {
        this.D = maxSessionsToday;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StatisticsData{");
        stringBuffer.append("domain=").append(this.x);
        stringBuffer.append(", timestamp=").append(this.y);
        stringBuffer.append(", clusterNodesCount=").append(this.A);
        stringBuffer.append(", heapMax=").append(this.B);
        stringBuffer.append(", version=").append(this.J);
        stringBuffer.append(", installation_id=").append(this.I);
        stringBuffer.append(", heapUsed=").append(this.C);
        stringBuffer.append(", maxSessionsToday=").append(this.D);
        stringBuffer.append(", maxSessionsYesterday=").append(this.E);
        stringBuffer.append(", uptime=").append(this.F);
        stringBuffer.append(", usersActive=").append(this.G);
        stringBuffer.append(", usersOnline=").append(this.H);
        stringBuffer.append(", version=").append(this.getVersion());
        stringBuffer.append(", vhosts=").append(this.K);
        stringBuffer.append(", additionalData='").append(this.z).append('\'');
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static /* synthetic */ void a(StatisticsData statisticsData, String string) {
        statisticsData.J = string;
    }

    private static /* synthetic */ void a(StatisticsData statisticsData, Element element) {
        statisticsData.I = element.getCData();
    }
}

