/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.server.cluster.strategy;

import tigase.xmpp.jid.JID;

import java.util.Random;

/**
 * @author andrzej
 */
public class CacheContentAbstractTest {

	private static final int loop = 100000000;
	private JID[] jids;
	private JID[] nodes;
	private Random random = new Random();

	public void performanceTest(CacheContenerIfc cache) {
		nodes = new JID[5];
		for (int i = 0; i < nodes.length; i++) {
			nodes[i] = JID.jidInstanceNS("node-" + i + "@example.com");
		}
		jids = new JID[10000];
		for (int i = 0; i < jids.length; i++) {
			jids[i] = JID.jidInstanceNS("user-" + i + "@example.com/resource-1");
		}

		long start = System.currentTimeMillis();

		for (int i = 0; i < loop; i++) {
			ConnectionRecordExt rec = new ConnectionRecordExt();

			JID node = nodes[(int) (System.currentTimeMillis() % nodes.length)];
			JID jid = jids[random.nextInt(jids.length)];

			rec.setRecordFields(node, jid, jid.toString(), jid);

			if (i < (loop / 2)) {
				cache.usersConnected(rec);
			} else {
				cache.userDisconnected(rec);
			}
		}

		long end = System.currentTimeMillis();

		System.out.println("test for " + cache.getClass().getCanonicalName() + " executed in " + (end - start) + "ms");
	}

}
