/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.modules;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;

public abstract class AbstractModule
extends tigase.component.modules.AbstractModule {
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        this.processPacket(packet).whenComplete((packet2, throwable) -> {
            if (throwable != null) {
                this.sendExeception(packet, (Throwable)throwable);
            } else {
                this.writer.write(packet2);
            }
        });
    }

    public abstract CompletableFuture<Packet> processPacket(Packet var1) throws ComponentException, TigaseStringprepException;

    public ComponentException convertThrowable(Throwable ex) {
        return ex instanceof ComponentException ? (ComponentException)ex : new ComponentException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), ex);
    }

    public void sendExeception(Packet packet, Throwable ex) {
        try {
            StanzaType stanzaType = packet.getType();
            if (stanzaType == StanzaType.error) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.log(Level.FINER, packet.getElemName() + " stanza already with type='error' ignored", ex);
                }
                return;
            }
            this.log.log(Level.FINEST, () -> "Sending back exception for " + packet.toString() + ", exception:\n" + this.a(ex));
            Packet packet2 = this.convertThrowable(ex).makeElement(packet, true);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Sending back: " + packet2.toString());
            }
            this.writer.write(packet2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String a(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

