/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tigase.meet.jingle.Description;
import tigase.xml.Element;

public class HdrExt {
    private final String a;
    private final String b;
    private final Description.Senders c;

    public static HdrExt from(Element el) {
        if ("rtp-hdrext".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0".equals(el.getXMLNS())) {
            String string = el.getAttributeStaticStr("id");
            String string2 = el.getAttributeStaticStr("uri");
            String string3 = el.getAttributeStaticStr("senders");
            if (string == null || string2 == null) {
                return null;
            }
            return new HdrExt(string, string2, string3 == null ? Description.Senders.both : Description.Senders.valueOf(string3));
        }
        return null;
    }

    public static List<HdrExt> from(String[] lines) {
        return Arrays.stream(lines).filter(string -> string.startsWith("a=extmap:")).map(string -> string.substring("a=extmap:".length())).map(string -> string.split(" ")).filter(stringArray -> ((String[])stringArray).length > 1 && !stringArray[0].contains("/")).map(stringArray -> new HdrExt(stringArray[0], stringArray[1], Description.Senders.both)).collect(Collectors.toList());
    }

    public HdrExt(String id, String uri, Description.Senders senders) {
        this.a = id;
        this.b = uri;
        this.c = senders;
    }

    public String getId() {
        return this.a;
    }

    public String getUri() {
        return this.b;
    }

    public Description.Senders getSenders() {
        return this.c;
    }

    public Element toElement() {
        Element element = new Element("rtp-hdrext");
        element.setXMLNS("urn:xmpp:jingle:apps:rtp:rtp-hdrext:0");
        element.setAttribute("id", this.a);
        element.setAttribute("uri", this.b);
        if (this.c != Description.Senders.both) {
            element.setAttribute("senders", this.c.name());
        }
        return element;
    }

    public String toSDP() {
        return "a=extmap:" + this.a + " " + this.b;
    }
}

