/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Optional;
import tigase.xml.Element;

public class Encryption {
    private final String a;
    private final String b;
    private final Optional<String> c;
    private final String d;

    public static Encryption from(Element el) {
        if ("crypto".equals(el.getName())) {
            String string = el.getAttributeStaticStr("crypto-suite");
            String string2 = el.getAttributeStaticStr("key-params");
            Optional<String> optional = Optional.ofNullable(el.getAttributeStaticStr("session-params"));
            String string3 = el.getAttributeStaticStr("tag");
            if (string == null || string2 == null || string3 == null) {
                return null;
            }
            return new Encryption(string, string2, optional, string3);
        }
        return null;
    }

    public Encryption(String cryptoSuite, String keyParams, Optional<String> sessionParams, String tag) {
        this.a = cryptoSuite;
        this.b = keyParams;
        this.c = sessionParams;
        this.d = tag;
    }

    public String getCryptoSuite() {
        return this.a;
    }

    public String getKeyParams() {
        return this.b;
    }

    public Optional<String> getSessionParams() {
        return this.c;
    }

    public String getTag() {
        return this.d;
    }

    public Element toElement() {
        Element element = new Element("crypto");
        element.setAttribute("crypto-suite", this.a);
        element.setAttribute("key-params", this.b);
        this.c.ifPresent(string -> element.setAttribute("session-params", string));
        element.setAttribute("tag", this.d);
        return element;
    }

    public String toSDP() {
        StringBuilder stringBuilder = new StringBuilder("a=crypto:").append(this.d).append(" ").append(this.a).append(" ").append(this.b);
        this.c.ifPresent(string -> stringBuilder.append(" ").append((String)string));
        return stringBuilder.toString();
    }
}

