/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.meet.jingle.Encryption;
import tigase.meet.jingle.HdrExt;
import tigase.meet.jingle.Payload;
import tigase.meet.jingle.SSRC;
import tigase.meet.jingle.SSRCGroup;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class Description {
    private final String a;
    private final Optional<String> b;
    private final List<Payload> c;
    private final Optional<String> d;
    private final List<Encryption> e;
    private final boolean f;
    private final List<SSRC> g;
    private final List<SSRCGroup> h;
    private final List<HdrExt> i;

    public static Description from(Element el) {
        return Description.from(el, true);
    }

    public static Description from(Element el, boolean ignoreSRTP) {
        if ("description".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:1".equals(el.getXMLNS())) {
            String string = el.getAttributeStaticStr("media");
            if (string == null) {
                return null;
            }
            Optional<String> optional = Optional.ofNullable(el.getAttributeStaticStr("ssrc"));
            List list = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
            List<Payload> list2 = list.stream().map(Payload::from).filter(Objects::nonNull).collect(Collectors.toList());
            Optional<String> optional2 = Optional.ofNullable(el.getChild("bandwidth")).map(element -> element.getAttributeStaticStr("type"));
            boolean bl = el.getChild("rtcp-mux") != null;
            List<Encryption> list3 = ignoreSRTP ? Collections.emptyList() : Optional.ofNullable(el.getChild("encryption")).map(element -> element.getChildren()).orElse(Collections.emptyList()).stream().map(Encryption::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<SSRC> list4 = list.stream().map(SSRC::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<SSRCGroup> list5 = list.stream().map(SSRCGroup::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<HdrExt> list6 = list.stream().map(HdrExt::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Description(string, optional, list2, optional2, list3, bl, list4, list5, list6);
        }
        return null;
    }

    public Description(String media, Optional<String> ssrc, List<Payload> payloads, Optional<String> bandwidth, List<Encryption> encryptions, boolean rtcpMux, List<SSRC> ssrcs, List<SSRCGroup> ssrcGroups, List<HdrExt> hdrExts) {
        this.a = media;
        this.b = ssrc;
        this.c = payloads;
        this.d = bandwidth;
        this.e = encryptions;
        this.f = rtcpMux;
        this.g = ssrcs;
        this.h = ssrcGroups;
        this.i = hdrExts;
    }

    public String getMedia() {
        return this.a;
    }

    public Optional<String> getSsrc() {
        return this.b;
    }

    public List<Payload> getPayloads() {
        return this.c;
    }

    public Optional<String> getBandwidth() {
        return this.d;
    }

    public List<Encryption> getEncryptions() {
        return this.e;
    }

    public boolean isRtcpMux() {
        return this.f;
    }

    public List<SSRC> getSsrcs() {
        return this.g;
    }

    public List<SSRCGroup> getSsrcGroups() {
        return this.h;
    }

    public List<HdrExt> getHdrExts() {
        return this.i;
    }

    public Description cloneWithSSRCsOnly() {
        return new Description(this.a, this.b, Collections.emptyList(), Optional.empty(), Collections.emptyList(), false, this.g, this.h, Collections.emptyList());
    }

    public Description withSSRCs(List<SSRC> ssrcs, List<SSRCGroup> ssrcGroups) {
        return new Description(this.a, this.b, this.c, this.d, this.e, this.f, ssrcs, ssrcGroups, this.i);
    }

    public Element toElement() {
        return this.toElement(true);
    }

    public Element toElement(boolean ignoreSRTP) {
        Element element = new Element("description");
        element.setXMLNS("urn:xmpp:jingle:apps:rtp:1");
        element.setAttribute("media", this.a);
        if (this.f) {
            element.addChild((XMLNodeIfc)new Element("rtcp-mux"));
        }
        this.b.ifPresent(string -> element.setAttribute("ssrc", string));
        this.c.stream().map(Payload::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        if (!ignoreSRTP && !this.e.isEmpty()) {
            Element element2 = new Element("encryption");
            this.e.stream().map(Encryption::toElement).forEach(arg_0 -> ((Element)element2).addChild(arg_0));
            element.addChild((XMLNodeIfc)element2);
        }
        this.h.stream().map(SSRCGroup::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        this.g.stream().map(SSRC::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        this.i.stream().map(HdrExt::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    public static final class Senders
    extends Enum<Senders> {
        public static final /* enum */ Senders initiator = new Senders();
        public static final /* enum */ Senders responder = new Senders();
        public static final /* enum */ Senders both = new Senders();
        private static final /* synthetic */ Senders[] a;

        public static Senders[] values() {
            return (Senders[])a.clone();
        }

        public static Senders valueOf(String name) {
            return Enum.valueOf(Senders.class, name);
        }

        private static /* synthetic */ Senders[] a() {
            return new Senders[]{initiator, responder, both};
        }

        static {
            a = Senders.a();
        }
    }
}

