/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;

public class LocalSubscriber {
    private static final Logger a = Logger.getLogger(LocalSubscriber.class.getCanonicalName());
    private final JanusVideoRoomPlugin b;
    private final Object c;
    private boolean d = false;
    private Listener e;

    public LocalSubscriber(JanusVideoRoomPlugin videoRoomPlugin, Object roomId) {
        this.b = videoRoomPlugin;
        this.c = roomId;
    }

    public JanusSession getSession() {
        return this.b.getSession();
    }

    public CompletableFuture<JSEP> joinAsSubscriber(Long privateId, long publisherId, List<JanusVideoRoomPlugin.Stream> streams) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", joining room as subscriber..");
        return ((CompletableFuture)this.b.execute("join", string, this.c, jsonGenerator -> {
            jsonGenerator.writeStringField("ptype", "subscriber");
            if (privateId != null) {
                jsonGenerator.writeNumberField("private_id", privateId.longValue());
            }
            jsonGenerator.writeFieldName("streams");
            jsonGenerator.writeStartArray();
            for (JanusVideoRoomPlugin.Stream stream : streams) {
                stream.write(jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }, null).thenApply(content -> {
            this.d = true;
            a.log(Level.FINER, () -> this.toString() + " updated subscribed streams: " + content.data.get("streams"));
            return content.jsep;
        })).whenComplete((jSEP, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to join room as subscriber!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", joined room as subscriber.");
                if (jSEP != null) {
                    this.e.receivedSubscriberSDP((JSEP)jSEP);
                }
            }
        });
    }

    public CompletableFuture<JSEP> subscribe(List<JanusVideoRoomPlugin.Stream> streams) {
        if (!this.d) {
            return this.joinAsSubscriber(null, streams.stream().mapToLong(JanusVideoRoomPlugin.Stream::getFeed).findFirst().getAsLong(), streams);
        }
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", subscribing streams " + streams + "..");
        return ((CompletableFuture)this.b.execute("subscribe", string, this.c, jsonGenerator -> {
            jsonGenerator.writeFieldName("streams");
            jsonGenerator.writeStartArray();
            for (JanusVideoRoomPlugin.Stream stream : streams) {
                stream.write(jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }, null).thenApply(content -> content.jsep)).whenComplete((jSEP, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to subscribe streams!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", subscribed streams.");
                if (jSEP != null) {
                    this.e.receivedSubscriberSDP((JSEP)jSEP);
                }
            }
        });
    }

    public CompletableFuture<JSEP> unsubscribe(long publisherId) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", unsubscribing streams with feed " + publisherId + "..");
        return ((CompletableFuture)this.b.execute("unsubscribe", string, this.c, jsonGenerator -> {
            jsonGenerator.writeFieldName("streams");
            jsonGenerator.writeStartArray();
            new JanusVideoRoomPlugin.Stream(publisherId, null).write(jsonGenerator);
            jsonGenerator.writeEndArray();
        }, null).thenApply(content -> content.jsep)).whenComplete((jSEP, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to unsubscribed streams!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", unsubscribed streams.");
                if (jSEP != null) {
                    this.e.receivedSubscriberSDP((JSEP)jSEP);
                }
            }
        });
    }

    public CompletableFuture<Void> start(JSEP jsep) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", starting stream..");
        return ((CompletableFuture)this.b.execute("start", string, this.c, jsonGenerator -> {}, jsep).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("started"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to start stream!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", stream started.");
            }
        });
    }

    public CompletableFuture<Void> sendCandidate(JanusPlugin.Candidate candidate) {
        String string = this.b.getSession().nextTransactionId();
        a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", sending candidate " + candidate + "..");
        return this.b.sendTrickle(string, candidate).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.toString() + ", transaction " + string + ", failed to send candidate!");
            } else {
                a.log(Level.FINER, () -> this.toString() + ", transaction " + string + ", candidate sent.");
            }
        });
    }

    public void handleEvent(JanusVideoRoomPlugin.Content content) {
        if ("updated".equals(content.getVideoRoom()) && content.data.containsKey("streams")) {
            a.log(Level.FINER, () -> this.toString() + " updated subscribed streams: " + content.data.get("streams"));
            if (content.jsep != null) {
                this.e.receivedSubscriberSDP(content.jsep);
            }
        }
    }

    public void receivedCandidate(JanusPlugin.Candidate candidate) {
        this.e.receivedSubscriberCandidate(candidate);
    }

    public void setListener(Listener listener) {
        this.e = listener;
    }

    public static interface Listener {
        public void receivedSubscriberSDP(JSEP var1);

        public void receivedSubscriberCandidate(JanusPlugin.Candidate var1);
    }
}

