/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusException;
import tigase.meet.janus.JanusSession;

public abstract class JanusPlugin<T extends Content> {
    private final JanusSession a;
    private final long b;

    public static <T extends JanusPlugin> T newInstance(Class<T> pluginClass, JanusSession session, Map<String, Object> data) {
        try {
            return (T)((JanusPlugin)pluginClass.getDeclaredConstructor(JanusSession.class, Map.class).newInstance(session, data));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("Class " + pluginClass + " does not contain required constructor!", exception);
        }
    }

    protected JanusPlugin(JanusSession session, Map<String, Object> data) {
        if (data == null) {
            throw new IllegalArgumentException("Missing 'data'!");
        }
        Long l = (Long)data.get("id");
        if (l == null) {
            throw new IllegalArgumentException("Missing handle id!");
        }
        this.a = session;
        this.b = l;
    }

    public abstract String getId();

    public abstract void handleEvent(T var1);

    public void handleTrickle(Map<String, Object> trickle) {
        List list = (List)trickle.get("candidates");
        if (list != null) {
            for (Map map : list) {
                if (map.containsKey("completed")) continue;
                this.receivedCandidate(Candidate.fromMap(map));
            }
        } else {
            Object object = trickle.get("candidate");
            if (object instanceof Map && !((Map)object).containsKey("completed")) {
                this.receivedCandidate(Candidate.fromMap((Map)object));
            }
        }
    }

    protected abstract void receivedCandidate(Candidate var1);

    public JanusSession getSession() {
        return this.a;
    }

    public long getHandleId() {
        return this.b;
    }

    public CompletableFuture<T> execute(String transaction, JanusConnection.RequestGenerator bodyGenerator, JSEP jsep) {
        return this.a.execute("message", transaction, (JsonGenerator jsonGenerator) -> {
            jsonGenerator.writeNumberField("handle_id", this.b);
            if (bodyGenerator != null) {
                jsonGenerator.writeFieldName("body");
                jsonGenerator.writeStartObject();
                bodyGenerator.accept(jsonGenerator);
                jsonGenerator.writeEndObject();
            }
            if (jsep != null) {
                jsep.write(jsonGenerator);
            }
        }).thenApply(this::extractData);
    }

    public CompletableFuture<Void> sendMessage(String transaction, JanusConnection.RequestGenerator bodyGenerator, JSEP jsep) {
        return this.a.send("message", transaction, jsonGenerator -> {
            jsonGenerator.writeNumberField("handle_id", this.b);
            if (bodyGenerator != null) {
                jsonGenerator.writeFieldName("body");
                jsonGenerator.writeStartObject();
                bodyGenerator.accept(jsonGenerator);
                jsonGenerator.writeEndObject();
            }
            if (jsep != null) {
                jsep.write(jsonGenerator);
            }
        }).thenApply(void_ -> null);
    }

    public CompletableFuture<Void> sendTrickle(String transaction, JanusConnection.RequestGenerator bodyGenerator) {
        return this.a.send("trickle", transaction, jsonGenerator -> {
            jsonGenerator.writeNumberField("handle_id", this.b);
            bodyGenerator.accept(jsonGenerator);
        });
    }

    public CompletableFuture<Void> sendTrickle(String transaction, Candidate candidate) {
        return this.sendTrickle(transaction, (JsonGenerator jsonGenerator) -> {
            jsonGenerator.writeFieldName("candidate");
            candidate.write(jsonGenerator);
        });
    }

    public CompletableFuture<Void> detach() {
        return this.a.detachPlugin(this);
    }

    protected T extractData(Map<String, Object> response) {
        Map map = (Map)response.get("plugindata");
        if (map == null) {
            throw new NullPointerException("Received JSON with 'plugindata' not set!");
        }
        if (!this.getId().equals(map.get("plugin"))) {
            throw new IllegalArgumentException("Received data by plugin " + this.getId() + " sent for " + map.get("plugin"));
        }
        Map map2 = (Map)map.get("data");
        if (map2 == null) {
            throw new NullPointerException("Missing 'data' for plugin!");
        }
        this.assertNotError(map2);
        return this.newContent(map2, JSEP.fromData(response));
    }

    protected abstract T newContent(Map<String, Object> var1, JSEP var2);

    protected void assertNotError(Map<String, Object> data) {
        Integer n = (Integer)data.get("error_code");
        if (n != null) {
            throw new JanusException(n, (String)data.get("error"));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{session=" + this.a.getSessionId() + ", handleId=" + this.b + "}";
    }

    public static class Candidate {
        private final String a;
        private final int b;
        private final String c;

        public static final Candidate fromMap(Map<String, Object> data) {
            return new Candidate((String)data.get("sdpMid"), ((Number)data.get("sdpMLineIndex")).intValue(), (String)data.get("candidate"));
        }

        public Candidate(String mid, int sdpMLineIndex, String candidate) {
            this.a = mid;
            this.b = sdpMLineIndex;
            this.c = candidate;
        }

        public String getMid() {
            return this.a;
        }

        public int getSdpMLineIndex() {
            return this.b;
        }

        public String getCandidate() {
            return this.c;
        }

        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("sdpMid", this.a);
            generator.writeNumberField("sdpMLineIndex", this.b);
            generator.writeStringField("candidate", this.c);
            generator.writeEndObject();
        }

        public String toString() {
            return "Candidate{mid='" + this.a + "', sdpMLineIndex=" + this.b + ", candidate='" + this.c + "'}";
        }
    }

    public static class Content {
        public final Map<String, Object> data;
        public final JSEP jsep;

        public Content(Map<String, Object> data, JSEP jsep) {
            this.data = data;
            this.jsep = jsep;
        }
    }
}

